/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.AssertionSerializer;
import io.gatling.core.stats.writer.BufferedFileChannelWriter;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessageSerializer;
import io.gatling.core.stats.writer.FileData;
import io.gatling.core.stats.writer.GroupMessageSerializer;
import io.gatling.core.stats.writer.ResponseMessageSerializer;
import io.gatling.core.stats.writer.RunMessageSerializer;
import io.gatling.core.stats.writer.UserEndMessageSerializer;
import io.gatling.core.stats.writer.UserStartMessageSerializer;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00114A!\u0003\u0006\u0003+!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015\t\u0007\u0001\"\u0011c\u0005Eaun\u001a$jY\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u00171\taa\u001e:ji\u0016\u0014(BA\u0007\u000f\u0003\u0015\u0019H/\u0019;t\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aE\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001-A\u0019q\u0003\u0007\u000e\u000e\u0003)I!!\u0007\u0006\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u0002\u00187%\u0011AD\u0003\u0002\t\r&dW\rR1uC\u0006\u0001\"/Z:vYR\u001cH)\u001b:fGR|'/\u001f\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nAAZ5mK*\u00111\u0005J\u0001\u0004]&|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\u0001\u0012A\u0001U1uQ\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\b\u0002\r\r|gNZ5h\u0013\tq3F\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u00124\u0007\u0005\u0002\u0018\u0001!)Qd\u0001a\u0001=!)\u0001f\u0001a\u0001S\u00051qN\\%oSR$\"A\u0007\u001c\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\t%t\u0017\u000e\u001e\t\u0003sqr!a\u0006\u001e\n\u0005mR\u0011!\u0005#bi\u0006<&/\u001b;fe6+7o]1hK&\u0011QH\u0010\u0002\u0005\u0013:LGO\u0003\u0002<\u0015\u00059qN\u001c$mkNDGCA!H!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011)f.\u001b;\t\u000b!+\u0001\u0019\u0001\u000e\u0002\t\u0011\fG/Y\u0001\n_:lUm]:bO\u0016$2!Q&Q\u0011\u0015ae\u00011\u0001N\u0003\u001diWm]:bO\u0016\u0004\"!\u000f(\n\u0005=s$!\u0003'pC\u0012,e/\u001a8u\u0011\u0015Ae\u00011\u0001\u001b\u0003\u001dygn\u0011:bg\"$2!Q*a\u0011\u0015!v\u00011\u0001V\u0003\u0015\u0019\u0017-^:f!\t1VL\u0004\u0002X7B\u0011\u0001lQ\u0007\u00023*\u0011!\fF\u0001\u0007yI|w\u000e\u001e \n\u0005q\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001X\"\t\u000b!;\u0001\u0019\u0001\u000e\u0002\r=t7\u000b^8q)\t\t5\rC\u0003I\u0011\u0001\u0007!\u0004")
public final class LogFileDataWriter
extends DataWriter<FileData> {
    private final Path resultsDirectory;
    private final GatlingConfiguration configuration;

    @Override
    public FileData onInit(DataWriterMessage.Init init) {
        BufferedFileChannelWriter writer = BufferedFileChannelWriter$.MODULE$.apply(init.runMessage().runId(), this.resultsDirectory, this.configuration);
        AssertionSerializer assertionSerializer = new AssertionSerializer(writer);
        init.assertions().foreach((Function1 & Serializable)assertion -> {
            assertionSerializer.serialize(assertion);
            return BoxedUnit.UNIT;
        });
        new RunMessageSerializer(writer).serialize(init.runMessage());
        return new FileData(new UserStartMessageSerializer(writer), new UserEndMessageSerializer(writer), new ResponseMessageSerializer(writer), new GroupMessageSerializer(writer), new ErrorMessageSerializer(writer), writer);
    }

    @Override
    public void onFlush(FileData data) {
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, FileData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserStart) {
            DataWriterMessage.LoadEvent.UserStart userStart = (DataWriterMessage.LoadEvent.UserStart)loadEvent;
            data.userStartMessageSerializer().serialize(userStart);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserEnd) {
            DataWriterMessage.LoadEvent.UserEnd userEnd = (DataWriterMessage.LoadEvent.UserEnd)loadEvent;
            data.userEndMessageSerializer().serialize(userEnd);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Group) {
            DataWriterMessage.LoadEvent.Group group = (DataWriterMessage.LoadEvent.Group)loadEvent;
            data.groupMessageSerializer().serialize(group);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            data.responseMessageSerializer().serialize(response);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            data.errorMessageSerializer().serialize(error);
            return;
        }
    }

    @Override
    public void onCrash(String cause, FileData data) {
    }

    @Override
    public void onStop(FileData data) {
        data.writer().close();
    }

    public LogFileDataWriter(Path resultsDirectory, GatlingConfiguration configuration) {
        this.resultsDirectory = resultsDirectory;
        this.configuration = configuration;
    }
}

