/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.actor.Cancellable;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.DataWriterMessage$Flush$;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.UserCounters;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055b!B\u0007\u000f\u0005QA\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011)\u0002!\u0011!Q\u0001\n-BQ!\r\u0001\u0005\u0002IBQA\u000e\u0001\u0005B]BQ!\u0011\u0001\u0005B\tCQa\u0013\u0001\u0005B1CQa\u0015\u0001\u0005\nQCQa\u0018\u0001\u0005\n\u0001DQA\u001a\u0001\u0005\n\u001dDQa\u001f\u0001\u0005\nqDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002(\u0001!\t%!\u000b\u0003#\r{gn]8mK\u0012\u000bG/Y,sSR,'O\u0003\u0002\u0010!\u00051qO]5uKJT!!\u0005\n\u0002\u000bM$\u0018\r^:\u000b\u0005M!\u0012\u0001B2pe\u0016T!!\u0006\f\u0002\u000f\u001d\fG\u000f\\5oO*\tq#\u0001\u0002j_N\u0011\u0001!\u0007\t\u00045miR\"\u0001\b\n\u0005qq!A\u0003#bi\u0006<&/\u001b;feB\u0011!DH\u0005\u0003?9\u00111bQ8og>dW\rR1uC\u0006)1\r\\8dW\u000e\u0001\u0001CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0011)H/\u001b7\u000b\u0005\u001d\"\u0012aB2p[6|gn]\u0005\u0003S\u0011\u0012Qa\u00117pG.\fQbY8oM&<WO]1uS>t\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0013\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001'\f\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r\u0019D'\u000e\t\u00035\u0001AQ\u0001I\u0002A\u0002\tBQAK\u0002A\u0002-\naa\u001c8J]&$HCA\u000f9\u0011\u0015ID\u00011\u0001;\u0003\u0011Ig.\u001b;\u0011\u0005mrdB\u0001\u000e=\u0013\tid\"A\tECR\fwK]5uKJlUm]:bO\u0016L!a\u0010!\u0003\t%s\u0017\u000e\u001e\u0006\u0003{9\tqa\u001c8GYV\u001c\b\u000e\u0006\u0002D\u0013B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n!QK\\5u\u0011\u0015QU\u00011\u0001\u001e\u0003\u0011!\u0017\r^1\u0002\u0013=tW*Z:tC\u001e,GcA\"N%\")aJ\u0002a\u0001\u001f\u00069Q.Z:tC\u001e,\u0007CA\u001eQ\u0013\t\t\u0006IA\u0005M_\u0006$WI^3oi\")!J\u0002a\u0001;\u0005\u0011rN\\+tKJ\u001cF/\u0019:u\u001b\u0016\u001c8/Y4f)\r\u0019UK\u0018\u0005\u0006-\u001e\u0001\raV\u0001\u0005kN,'\u000f\u0005\u0002Y7:\u00111(W\u0005\u00035\u0002\u000b\u0011\u0002T8bI\u00163XM\u001c;\n\u0005qk&!C+tKJ\u001cF/\u0019:u\u0015\tQ\u0006\tC\u0003K\u000f\u0001\u0007Q$\u0001\tp]V\u001bXM]#oI6+7o]1hKR\u00191)Y3\t\u000bYC\u0001\u0019\u00012\u0011\u0005a\u001b\u0017B\u00013^\u0005\u001d)6/\u001a:F]\u0012DQA\u0013\u0005A\u0002u\t\u0011c\u001c8SKN\u0004xN\\:f\u001b\u0016\u001c8/Y4f)\r\u0019\u0005.\u001c\u0005\u0006S&\u0001\rA[\u0001\te\u0016\u001c\bo\u001c8tKB\u0011\u0001l[\u0005\u0003Yv\u0013\u0001BU3ta>t7/\u001a\u0005\u0006\u0015&\u0001\r!\b\u0015\u0005\u0013=<\b\u0010\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!A.\u00198h\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003!M+\b\u000f\u001d:fgN<\u0016M\u001d8j]\u001e\u001c\u0018!\u0002<bYV,G&A=\"\u0003i\f\u0001e\u001c:h]]\f'\u000f\u001e:f[>4XM\u001d\u0018xCJ$8O\f'jgR\f\u0005\u000f]3oI\u0006qqN\\#se>\u0014X*Z:tC\u001e,G\u0003B\"~\u0003\u000bAQA \u0006A\u0002}\fQ!\u001a:s_J\u00042\u0001WA\u0001\u0013\r\t\u0019!\u0018\u0002\u0006\u000bJ\u0014xN\u001d\u0005\u0006\u0015*\u0001\r!H\u0001\b_:\u001c%/Y:i)\u0015\u0019\u00151BA\u0013\u0011\u001d\tia\u0003a\u0001\u0003\u001f\tQaY1vg\u0016\u0004B!!\u0005\u0002 9!\u00111CA\u000e!\r\t)\"R\u0007\u0003\u0003/Q1!!\u0007\"\u0003\u0019a$o\\8u}%\u0019\u0011QD#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\"\u0012\u0005\u0006\u0015.\u0001\r!H\u0001\u0007_:\u001cFo\u001c9\u0015\u0007\r\u000bY\u0003C\u0003K\u0019\u0001\u0007Q\u0004")
public final class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;

    @Override
    public ConsoleData onInit(DataWriterMessage.Init init2) {
        Cancellable timer = this.scheduler().scheduleAtFixedRate(this.configuration.data().console().writePeriod(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.self().$bang(DataWriterMessage$Flush$.MODULE$));
        ConsoleData data = new ConsoleData(this.clock.nowMillis(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss O").withZone(init2.runMessage().zoneId()), timer);
        init2.scenarios().foreach((Function1 & Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        return data;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, ZonedDateTime.now(), data.dateTimeFormatter());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, ConsoleData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserStart) {
            DataWriterMessage.LoadEvent.UserStart userStart = (DataWriterMessage.LoadEvent.UserStart)loadEvent;
            this.onUserStartMessage(userStart, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserEnd) {
            DataWriterMessage.LoadEvent.UserEnd userEnd = (DataWriterMessage.LoadEvent.UserEnd)loadEvent;
            this.onUserEndMessage(userEnd, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            this.onResponseMessage(response, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            this.onErrorMessage(error, data);
            return;
        }
    }

    private void onUserStartMessage(DataWriterMessage.LoadEvent.UserStart user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userStart();
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
            return;
        }
    }

    private void onUserEndMessage(DataWriterMessage.LoadEvent.UserEnd user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userDone();
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
            return;
        }
    }

    private void onResponseMessage(DataWriterMessage.LoadEvent.Response response, ConsoleData data) {
        String requestPath = ((IterableOnceOps)response.groupHierarchy().$colon$plus((Object)response.name())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            return;
        }
        if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            return;
        }
        throw new MatchError((Object)status);
    }

    private void onErrorMessage(DataWriterMessage.LoadEvent.Error error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        data.timer().cancel();
        if (!data.complete()) {
            this.onFlush(data);
            return;
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        super("console-data-writer");
    }
}

