/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.FeederOptions;
import io.gatling.core.feeder.FeederSource;
import io.gatling.core.feeder.InMemoryFeeder$;
import io.gatling.core.feeder.ZippedResourceCache$;
import io.gatling.core.json.Json$;
import io.gatling.core.json.JsonParsers;
import io.gatling.core.util.Resource;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005m3Qa\u0002\u0005\u0003\u0019AA\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!)Q\u0006\u0001C\u0001]!)\u0011\u0002\u0001C!e!)q\t\u0001C!\u0011\")A\u000b\u0001C!+\n!\"j]8o\r&dWMR3fI\u0016\u00148k\\;sG\u0016T!!\u0003\u0006\u0002\r\u0019,W\rZ3s\u0015\tYA\"\u0001\u0003d_J,'BA\u0007\u000f\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aD\u0001\u0003S>\u001c2\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0019\u0001$G\u000e\u000e\u0003!I!A\u0007\u0005\u0003\u0019\u0019+W\rZ3s'>,(oY3\u0011\u0005Ia\u0012BA\u000f\u0014\u0005\r\te._\u0001\te\u0016\u001cx.\u001e:dK\u000e\u0001\u0001CA\u0011%\u001b\u0005\u0011#BA\u0012\u000b\u0003\u0011)H/\u001b7\n\u0005\u0015\u0012#\u0001\u0003*fg>,(oY3\u0002\u0017)\u001cxN\u001c)beN,'o\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0003U)\tAA[:p]&\u0011A&\u000b\u0002\f\u0015N|g\u000eU1sg\u0016\u00148/\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004C\u0001\r\u0001\u0011\u0015q2\u00011\u0001!\u0011\u001513\u00011\u0001()\r\u0019$h\u0010\t\u0004i]ZbB\u0001\r6\u0013\t1\u0004\"A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$A\u0002$fK\u0012,'O\u0003\u00027\u0011!)1\b\u0002a\u0001y\u00059q\u000e\u001d;j_:\u001c\bc\u0001\r>7%\u0011a\b\u0003\u0002\u000e\r\u0016,G-\u001a:PaRLwN\\:\t\u000b\u0001#\u0001\u0019A!\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t\u0011U)D\u0001D\u0015\t!%\"\u0001\u0004d_:4\u0017nZ\u0005\u0003\r\u000e\u0013AcR1uY&twmQ8oM&<WO]1uS>t\u0017\u0001\u00028b[\u0016,\u0012!\u0013\t\u0003\u0015Fs!aS(\u0011\u00051\u001bR\"A'\u000b\u00059{\u0012A\u0002\u001fs_>$h(\u0003\u0002Q'\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u00016#\u0001\u0007sK\u000e|'\u000fZ:D_VtG\u000fF\u0002W3j\u0003\"AE,\n\u0005a\u001b\"aA%oi\")1H\u0002a\u0001y!)\u0001I\u0002a\u0001\u0003\u0002")
public final class JsonFileFeederSource
implements FeederSource<Object> {
    private final Resource resource;
    private final JsonParsers jsonParsers;

    @Override
    public Iterator<Map<String, Object>> feeder(FeederOptions<Object> options, GatlingConfiguration configuration) {
        return (Iterator)Using$.MODULE$.resource((Object)ZippedResourceCache$.MODULE$.unzipped(this.resource, options.unzip()).inputStream(), (Function1 & Serializable)is -> {
            JsonNode node = $this.jsonParsers.parse((InputStream)is);
            Predef$.MODULE$.require(node.isArray(), (Function0 & Serializable)() -> "Root element of JSON feeder file isn't an array");
            Vector records = CollectionConverters$.MODULE$.IteratorHasAsScala(node.elements()).asScala().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends JsonNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1.isObject()) {
                        return (B1)((Map)Json$.MODULE$.asScala(A1));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(JsonNode x1) {
                    JsonNode jsonNode = x1;
                    return jsonNode.isObject();
                }
            }).toVector();
            return InMemoryFeeder$.MODULE$.apply(records, options.conversion(), options.strategy());
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Override
    public String name() {
        return "json(" + this.resource.name() + ")";
    }

    @Override
    public int recordsCount(FeederOptions<Object> options, GatlingConfiguration configuration) {
        return BoxesRunTime.unboxToInt((Object)Using$.MODULE$.resource((Object)ZippedResourceCache$.MODULE$.unzipped(this.resource, options.unzip()).inputStream(), (Function1 & Serializable)is -> BoxesRunTime.boxToInteger((int)Json$.MODULE$.arrayOfObjectsLength(is, this.jsonParsers)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
    }

    public JsonFileFeederSource(Resource resource, JsonParsers jsonParsers) {
        this.resource = resource;
        this.jsonParsers = jsonParsers;
    }
}

