/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.stats.ErrorStats;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ConsoleStatsFormat$ {
    public static final ConsoleStatsFormat$ MODULE$ = new ConsoleStatsFormat$();
    private static final int NumberLength = 9;
    private static final int PercentageLength = 8;
    private static final int ConsoleWidth = 120;
    private static final String Header = "> ";
    private static final int HeaderLength = MODULE$.Header().length();
    private static final String NewBlock = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("="), MODULE$.ConsoleWidth());
    private static final int ErrorFirstLineLength = MODULE$.ConsoleWidth() - MODULE$.HeaderLength() - MODULE$.NumberLength() - MODULE$.PercentageLength() - 2;
    private static final int ErrorSecondLineLength = MODULE$.ErrorFirstLineLength() + MODULE$.HeaderLength();

    public int NumberLength() {
        return NumberLength;
    }

    public int PercentageLength() {
        return PercentageLength;
    }

    public int ConsoleWidth() {
        return ConsoleWidth;
    }

    public String Header() {
        return Header;
    }

    public int HeaderLength() {
        return HeaderLength;
    }

    public String NewBlock() {
        return NewBlock;
    }

    public <T> String formatNumber(Option<T> value, Numeric<T> evidence$1) {
        String string;
        Option<T> option = value;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            string = NumberHelper.RichDouble$.MODULE$.toPrintableString$extension(NumberHelper$.MODULE$.RichDouble(((Numeric)Predef$.MODULE$.implicitly(evidence$1)).toDouble(v)));
        } else {
            string = "-";
        }
        String string2 = string;
        return StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(string2), this.NumberLength());
    }

    public <T> String formatNumber(T value, Numeric<T> evidence$2) {
        String string = NumberHelper.RichDouble$.MODULE$.toPrintableString$extension(NumberHelper$.MODULE$.RichDouble(((Numeric)Predef$.MODULE$.implicitly(evidence$2)).toDouble(value)));
        return StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(string), this.NumberLength());
    }

    public String formatPercentage(double value) {
        return StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString("(" + NumberHelper.RichDouble$.MODULE$.toPrintableString$extension(NumberHelper$.MODULE$.RichDouble(value)) + "%)"), this.PercentageLength());
    }

    private int ErrorFirstLineLength() {
        return ErrorFirstLineLength;
    }

    private int ErrorSecondLineLength() {
        return ErrorSecondLineLength;
    }

    public StringBuilder writeError(StringBuilder sb, ErrorStats errors) {
        String message = errors.message();
        int firstLineLen = package$.MODULE$.min(message.length(), this.ErrorFirstLineLength());
        sb.append(this.Header() + StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString(message.substring(0, firstLineLen)), this.ErrorFirstLineLength()) + " " + this.formatNumber((Object)BoxesRunTime.boxToInteger((int)errors.count()), (Numeric)Numeric.IntIsIntegral$.MODULE$) + " " + this.formatPercentage(errors.percentage()));
        if (message.length() > this.ErrorFirstLineLength()) {
            return sb.append(StringHelper$.MODULE$.Eol()).append(StringHelper.RichString$.MODULE$.truncate$extension(StringHelper$.MODULE$.RichString(message.substring(this.ErrorFirstLineLength())), this.ErrorSecondLineLength()));
        }
        return sb;
    }

    public String formatSubTitleWithStatuses(String title) {
        String titleWrappedWithSpaces = " " + title + " ";
        return "----" + StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString(titleWrappedWithSpaces), this.ConsoleWidth() - 4 - 35, "-") + "|---Total---|-----OK----|----KO----";
    }

    private ConsoleStatsFormat$() {
    }
}

