/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats;

import io.gatling.commons.util.Clock;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine;
import io.gatling.core.stats.writer.ConsoleDataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.DataWriterType;
import io.gatling.core.stats.writer.DataWriterType$Console$;
import io.gatling.core.stats.writer.DataWriterType$File$;
import io.gatling.core.stats.writer.LogFileDataWriter$;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.gatling.core.structure.PopulationBuilder;
import io.gatling.core.structure.PopulationBuilder$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;

public final class DataWritersStatsEngine$ {
    public static final DataWritersStatsEngine$ MODULE$ = new DataWritersStatsEngine$();

    public DataWritersStatsEngine apply(SimulationParams simulationParams, RunMessage runMessage, ActorSystem system, Clock clock, Option<Path> resultsDirectory, GatlingConfiguration configuration) {
        List<PopulationBuilder> allPopulationBuilders = PopulationBuilder$.MODULE$.flatten(simulationParams.rootPopulationBuilders());
        List scenarios = allPopulationBuilders.map((Function1 & Serializable)pb -> new ShortScenarioDescription(pb.scenarioBuilder().name(), pb.injectionProfile().totalUserCount()));
        Seq dataWriters = (Seq)((IterableOps)configuration.data().dataWriters().map((Function1 & Serializable)x0$1 -> {
            DataWriterType dataWriterType = x0$1;
            if (DataWriterType$Console$.MODULE$.equals(dataWriterType)) {
                return new ConsoleDataWriter(runMessage, (Seq<ShortScenarioDescription>)scenarios, clock, configuration.data().console());
            }
            if (DataWriterType$File$.MODULE$.equals(dataWriterType)) {
                return LogFileDataWriter$.MODULE$.apply(runMessage, (Seq<ShortScenarioDescription>)scenarios, simulationParams.assertions(), (Path)resultsDirectory.getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("Can't use the file DataWriter without setting the results directory");
                }));
            }
            throw new MatchError((Object)dataWriterType);
        })).map((Function1 & Serializable)actor -> system.actorOf(actor));
        return new DataWritersStatsEngine((Seq<ActorRef<DataWriterMessage>>)dataWriters, system, clock);
    }

    private DataWritersStatsEngine$() {
    }
}

