/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.Adaptive$;
import io.gatling.core.feeder.Batch;
import io.gatling.core.feeder.Batch$;
import io.gatling.core.feeder.BatchedSeparatedValuesFeeder$;
import io.gatling.core.feeder.FeederLoadingMode;
import io.gatling.core.feeder.FeederOptions;
import io.gatling.core.feeder.FeederSource;
import io.gatling.core.feeder.InMemoryFeeder$;
import io.gatling.core.feeder.SeparatedValuesFeederSource$;
import io.gatling.core.feeder.SeparatedValuesParser$;
import io.gatling.core.util.Resource;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005m;QAC\u0006\t\u0002Q1QAF\u0006\t\u0002]AQAH\u0001\u0005\u0002}AQ\u0001I\u0001\u0005\n\u00052AAF\u0006\u0003U!A\u0011\u0006\u0002B\u0001B\u0003%!\u0005\u0003\u0005:\t\t\u0005\t\u0015!\u0003;\u0011!iDA!A!\u0002\u0013Q\u0004\"\u0002\u0010\u0005\t\u0003q\u0004\"\u0002\u0007\u0005\t\u0003\u001a\u0015aG*fa\u0006\u0014\u0018\r^3e-\u0006dW/Z:GK\u0016$WM]*pkJ\u001cWM\u0003\u0002\r\u001b\u00051a-Z3eKJT!AD\b\u0002\t\r|'/\u001a\u0006\u0003!E\tqaZ1uY&twMC\u0001\u0013\u0003\tIwn\u0001\u0001\u0011\u0005U\tQ\"A\u0006\u00037M+\u0007/\u0019:bi\u0016$g+\u00197vKN4U-\u001a3feN{WO]2f'\t\t\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\tQ!\u001e8{SB$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015j\u0011\u0001B;uS2L!a\n\u0013\u0003\u0011I+7o\\;sG\u0016DQ!K\u0002A\u0002\t\n\u0001B]3t_V\u00148-Z\n\u0004\taY\u0003cA\u000b-]%\u0011Qf\u0003\u0002\r\r\u0016,G-\u001a:T_V\u00148-\u001a\t\u0003_Yr!\u0001\r\u001b\u0011\u0005ERR\"\u0001\u001a\u000b\u0005M\u001a\u0012A\u0002\u001fs_>$h(\u0003\u000265\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$$A\u0005tKB\f'/\u0019;peB\u0011\u0011dO\u0005\u0003yi\u0011Aa\u00115be\u0006I\u0011/^8uK\u000eC\u0017M\u001d\u000b\u0005\u007f\u0001\u000b%\t\u0005\u0002\u0016\t!)\u0011\u0006\u0003a\u0001E!)\u0011\b\u0003a\u0001u!)Q\b\u0003a\u0001uQ\u0019AIT*\u0011\u0007\u0015C5J\u0004\u0002\u0016\r&\u0011qiC\u0001\ba\u0006\u001c7.Y4f\u0013\tI%J\u0001\u0004GK\u0016$WM\u001d\u0006\u0003\u000f.\u0001\"!\u0007'\n\u00055S\"aA!os\")q*\u0003a\u0001!\u00069q\u000e\u001d;j_:\u001c\bcA\u000bR]%\u0011!k\u0003\u0002\u000e\r\u0016,G-\u001a:PaRLwN\\:\t\u000bQK\u0001\u0019A+\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t1\u0016,D\u0001X\u0015\tAV\"\u0001\u0004d_:4\u0017nZ\u0005\u00035^\u0013AcR1uY&twmQ8oM&<WO]1uS>t\u0007")
public final class SeparatedValuesFeederSource
implements FeederSource<String> {
    private final Resource resource;
    private final char separator;
    private final char quoteChar;

    @Override
    public Iterator<Map<String, Object>> feeder(FeederOptions<String> options, GatlingConfiguration configuration) {
        Resource uncompressedResource = options.unzip() ? SeparatedValuesFeederSource$.MODULE$.io$gatling$core$feeder$SeparatedValuesFeederSource$$unzip(this.resource) : this.resource;
        return this.applyBatch$1(uncompressedResource, configuration, options);
    }

    private final Iterator applyBatch$1(Resource res, GatlingConfiguration configuration$1, FeederOptions options$1) {
        Iterator<Map<String, Object>> iterator;
        Charset charset = configuration$1.core().charset();
        FeederLoadingMode feederLoadingMode = options$1.loadingMode();
        if (feederLoadingMode instanceof Batch) {
            Batch batch = (Batch)feederLoadingMode;
            int bufferSize = batch.bufferSize();
            iterator = BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), bufferSize, charset);
        } else if (Adaptive$.MODULE$.equals(feederLoadingMode) && res.file().length() > configuration$1.core().feederAdaptiveLoadModeThreshold()) {
            iterator = BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), Batch$.MODULE$.DefaultBufferSize(), charset);
        } else {
            Vector records = (Vector)Using$.MODULE$.resource((Object)FileChannel.open(res.file().toPath(), new OpenOption[0]), (Function1 & Serializable)channel -> ((IterableOnceOps)SeparatedValuesParser$.MODULE$.stream($this.separator, $this.quoteChar, charset).apply(channel)).toVector(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            iterator = InMemoryFeeder$.MODULE$.apply(records, options$1.conversion(), options$1.strategy());
        }
        return iterator;
    }

    public SeparatedValuesFeederSource(Resource resource, char separator, char quoteChar) {
        this.resource = resource;
        this.separator = separator;
        this.quoteChar = quoteChar;
    }
}

