/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util;

import io.gatling.plugin.util.EnterpriseClient;
import io.gatling.plugin.util.EnterpriseClientException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class OkHttpEnterpriseClient
implements EnterpriseClient {
    private static final MediaType OCTET_STREAM_MEDIA_TYPE = MediaType.get((String)"application/octet-stream");
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final OkHttpClient okHttpClient;
    private final URL url;
    private final String token;

    public OkHttpEnterpriseClient(OkHttpClient okHttpClient, URL uRL, String string) {
        this.okHttpClient = okHttpClient;
        this.url = uRL;
        this.token = string;
    }

    public OkHttpEnterpriseClient(URL uRL, String string) {
        this(new OkHttpClient(), uRL, string);
    }

    private HttpUrl uploadPackageUrl(UUID uUID, File file) {
        return HttpUrl.get((URL)this.url).newBuilder().addPathSegment("artifacts").addPathSegment(uUID.toString()).addPathSegment("content").addQueryParameter("filename", file.getName()).build();
    }

    private Request uploadPackageRequest(UUID uUID, File file) {
        HttpUrl httpUrl = this.uploadPackageUrl(uUID, file);
        RequestBody requestBody = RequestBody.create((MediaType)OCTET_STREAM_MEDIA_TYPE, (File)file);
        return new Request.Builder().url(httpUrl).put(requestBody).header(AUTHORIZATION_HEADER, this.token).build();
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterpriseClientException {
        Request request = this.uploadPackageRequest(uUID, file);
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                return file.length();
            }
            switch (response.code()) {
                case 401: {
                    throw new EnterpriseClientException("Insufficient permissions on token");
                }
                case 413: {
                    throw new EnterpriseClientException("Package exceed maximum allowed size (5 Go)");
                }
                case 404: {
                    throw new EnterpriseClientException(String.format("Package with id %s does not exist", uUID));
                }
            }
            throw new EnterpriseClientException(String.format("Unhandled response (status code: %s, body: %s)", response.code(), response.body().string()));
        }
        catch (IOException iOException) {
            throw new EnterpriseClientException("Upload request failed", iOException);
        }
    }
}

