/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import io.gatling.plugin.client.http.api.AbstractApi;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.responses.LiveInformationResponse;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.RunNotFoundException;
import io.gatling.plugin.model.BuildTool;
import java.net.URL;
import java.util.Map;

public class RunsPluginApi
extends AbstractApi {
    private static final ApiPath RUN_PATH = ApiPath.of("runs");
    private static final ApiPath VIEW_LIVE_PATH = ApiPath.of("views", "live");
    private static final String PLUGIN_FLAVOR_HEADER = "X-Gatling-Plugin-Flavor";
    private static final String PLUGIN_VERSION_HEADER = "X-Gatling-Plugin-Version";
    private static final Map<BuildTool, String> BUILD_TOOL_TO_STRING = Map.of(BuildTool.JS_CLI, "npm", BuildTool.MAVEN, "maven", BuildTool.GRADLE, "gradle", BuildTool.SBT, "sbt");

    public RunsPluginApi(URL uRL, String string) {
        super(uRL, string);
    }

    public LiveInformationResponse getLiveInformation(String string, BuildTool buildTool, String string2) throws EnterprisePluginException {
        return this.getJson(RUN_PATH.append(string).append(VIEW_LIVE_PATH), Map.ofEntries(Map.entry(PLUGIN_FLAVOR_HEADER, BUILD_TOOL_TO_STRING.get((Object)buildTool)), Map.entry(PLUGIN_VERSION_HEADER, string2)), LiveInformationResponse.class, httpResponse -> {
            if (httpResponse.code == 404) {
                throw new RunNotFoundException(string);
            }
        });
    }
}

