/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gatling.plugin.util.ObjectsUtil;
import java.util.Map;
import java.util.Objects;

public class StartOptionsRequest {
    public final Map<String, String> extraSystemProperties;
    public final Map<String, String> extraEnvironmentVariables;
    public final String title;
    public final String description;

    @JsonCreator
    public StartOptionsRequest(@JsonProperty(value="extraSystemProperties", required=true) Map<String, String> map, @JsonProperty(value="extraEnvironmentVariables", required=true) Map<String, String> map2, @JsonProperty(value="title") String string, @JsonProperty(value="description") String string2) {
        ObjectsUtil.nonNullParam(map, "extraSystemProperties");
        ObjectsUtil.nonNullParam(map2, "extraEnvironmentVariables");
        this.extraSystemProperties = map;
        this.extraEnvironmentVariables = map2;
        this.title = string;
        this.description = string2;
    }

    public Map<String, String> getExtraSystemProperties() {
        return this.extraSystemProperties;
    }

    public Map<String, String> getExtraEnvironmentVariables() {
        return this.extraEnvironmentVariables;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.format("StartOptionsRequest{extraSystemProperties=%s, extraEnvironmentVariables=%s, runTitle='%s', runDescription='%s'}", this.extraSystemProperties, this.extraEnvironmentVariables, this.title, this.description);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StartOptionsRequest startOptionsRequest = (StartOptionsRequest)object;
        return Objects.equals(this.extraSystemProperties, startOptionsRequest.extraSystemProperties) && Objects.equals(this.extraEnvironmentVariables, startOptionsRequest.extraEnvironmentVariables) && Objects.equals(this.title, startOptionsRequest.title) && Objects.equals(this.description, startOptionsRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.extraSystemProperties, this.extraEnvironmentVariables, this.title, this.description);
    }
}

