/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.NoSimulationClassNameFoundException;
import io.gatling.plugin.exceptions.PackageEmptyException;
import io.gatling.plugin.exceptions.SimulationScannerIOException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.util.ObjectsUtil;
import io.gatling.scanner.AsmSimulationScanner;
import io.gatling.scanner.HighestJavaVersionClass;
import io.gatling.scanner.SimulationScanResult;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

abstract class PluginClient {
    protected final EnterpriseClient enterpriseClient;
    protected final PluginLogger logger;

    public PluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
    }

    protected long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        if (this.enterpriseClient.uploadPackageWithChecksum(uUID, file) == -1L) {
            this.logger.info("No code changes detected, skipping package upload");
        } else {
            this.logger.info("Package uploaded");
        }
        return file.length();
    }

    protected SimulationScanResult scanPackage(File file) throws EnterprisePluginException {
        SimulationScanResult simulationScanResult;
        try {
            simulationScanResult = AsmSimulationScanner.scan((File)file);
        }
        catch (IOException iOException) {
            throw new SimulationScannerIOException(file, iOException);
        }
        if (simulationScanResult.getHighestJavaVersionClass() == null) {
            throw new PackageEmptyException();
        }
        if (simulationScanResult.getSimulationClasses().isEmpty()) {
            throw new NoSimulationClassNameFoundException();
        }
        int n = Integer.parseInt(this.enterpriseClient.getServerInformation().versions.java.max);
        HighestJavaVersionClass highestJavaVersionClass = simulationScanResult.getHighestJavaVersionClass();
        if (highestJavaVersionClass.javaVersion > n) {
            throw new UnsupportedJavaVersionException(highestJavaVersionClass.clazz, highestJavaVersionClass.javaVersion, n);
        }
        return simulationScanResult;
    }

    protected List<String> simulationClassesFromCompatibleByteCodeFile(File file) throws EnterprisePluginException {
        return this.scanPackage(file).getSimulationClasses();
    }
}

