/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gatling.plugin.model.PackageFile;
import io.gatling.plugin.util.ObjectsUtil;
import java.util.Objects;
import java.util.UUID;

public final class Pkg {
    public final UUID id;
    public final UUID teamId;
    public final String name;
    public final PackageFile file;

    @JsonCreator
    public Pkg(@JsonProperty(value="id", required=true) UUID uUID, @JsonProperty(value="teamId") UUID uUID2, @JsonProperty(value="name", required=true) String string, @JsonProperty(value="file") PackageFile packageFile) {
        ObjectsUtil.nonNullParam(uUID, "id");
        ObjectsUtil.nonNullParam(string, "name");
        this.id = uUID;
        this.teamId = uUID2;
        this.name = string;
        this.file = packageFile;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pkg pkg = (Pkg)object;
        return this.id.equals(pkg.id) && Objects.equals(this.teamId, pkg.teamId) && this.name.equals(pkg.name) && Objects.equals(this.file, pkg.file);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.teamId, this.name, this.file);
    }

    public String toString() {
        return String.format("Package{id='%s',teamId='%s',name='%s',file='%s'}", this.id, this.teamId, this.name, this.file);
    }
}

