/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util;

import io.gatling.plugin.util.Os;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class JavaLocator {
    private JavaLocator() {
    }

    public static File getJavaExecutable() {
        String string = "java" + (Os.IS_WINDOWS ? ".exe" : "");
        String string2 = System.getProperty("java.home");
        if (string2 != null) {
            File file;
            Path path = Paths.get(string2, new String[0]);
            if (path.endsWith("jre") && (file = path.resolveSibling("bin").resolve(string).toFile()).isFile()) {
                return file;
            }
            file = path.resolve("bin").resolve(string).toFile();
            if (file.isFile()) {
                return file;
            }
            throw new IllegalStateException("Couldn't locate java in defined java.home system property.");
        }
        String string3 = System.getenv("JAVA_HOME");
        if (string3 == null) {
            throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
        }
        File file = Paths.get(string3, new String[0]).resolve("bin").resolve(string).toFile();
        if (file.isFile()) {
            return file;
        }
        throw new IllegalStateException("Couldn't locate java in defined JAVA_HOME environment variable.");
    }
}

