/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import io.gatling.plugin.util.ObjectsUtil;
import java.util.List;
import java.util.Objects;

public final class MetricsSummary {
    public final String date;
    public final String duration;
    public final double nbUsers;
    public final double nbRequest;
    public final double requestsSeconds;
    public final double failureRatio;
    public final List<ChildMetric> listMetric;

    public MetricsSummary(String string, String string2, double d, double d2, double d3, double d4, List<ChildMetric> list) {
        ObjectsUtil.nonNullParam(string, "date");
        ObjectsUtil.nonNullParam(string2, "duration");
        ObjectsUtil.nonNullParam(list, "listMetric");
        this.date = string;
        this.duration = string2;
        this.nbUsers = d;
        this.nbRequest = d2;
        this.requestsSeconds = d3;
        this.failureRatio = d4;
        this.listMetric = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetricsSummary metricsSummary = (MetricsSummary)object;
        return Objects.equals(this.date, metricsSummary.date) && Objects.equals(this.duration, metricsSummary.duration) && this.nbUsers == metricsSummary.nbUsers && this.nbRequest == metricsSummary.nbRequest && this.requestsSeconds == metricsSummary.requestsSeconds && this.failureRatio == metricsSummary.failureRatio && Objects.equals(this.listMetric, metricsSummary.listMetric);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.duration, this.nbUsers, this.nbRequest, this.requestsSeconds, this.failureRatio, this.listMetric);
    }

    public String toString() {
        return String.format("MetricsSummary{date='%s',duration='%s',nbUsers='%s',nbRequest='%s',requestsSeconds='%s',failureRatio='%s',listMetric='%s'}", this.date, this.duration, this.nbUsers, this.nbRequest, this.requestsSeconds, this.failureRatio, this.listMetric);
    }

    public static final class ChildMetric {
        public final String name;
        public final Double nbRequest;
        public final Double failureRatio;
        public final Double requestsSeconds;
        public final List<ChildMetric> children;

        public ChildMetric(String string, List<ChildMetric> list) {
            ObjectsUtil.nonNullParam(string, "name");
            ObjectsUtil.nonNullParam(list, "children");
            this.name = string;
            this.nbRequest = null;
            this.failureRatio = null;
            this.requestsSeconds = null;
            this.children = list;
        }

        public ChildMetric(String string, Double d, Double d2, Double d3) {
            ObjectsUtil.nonNullParam(string, "name");
            ObjectsUtil.nonNullParam(d, "nbRequest");
            ObjectsUtil.nonNullParam(d2, "failureRatio");
            ObjectsUtil.nonNullParam(d3, "requestsSeconds");
            this.name = string;
            this.nbRequest = d;
            this.failureRatio = d2;
            this.requestsSeconds = d3;
            this.children = null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ChildMetric childMetric = (ChildMetric)object;
            return Objects.equals(this.name, childMetric.name) && Objects.equals(this.nbRequest, childMetric.nbRequest) && Objects.equals(this.failureRatio, childMetric.failureRatio) && Objects.equals(this.requestsSeconds, childMetric.requestsSeconds) && Objects.equals(this.children, childMetric.children);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.nbRequest, this.failureRatio, this.requestsSeconds, this.children);
        }

        public String toString() {
            return String.format("ChildMetric{name='%s',nbRequest='%s',failureRatio='%s',requestsSeconds='%s',children='%s'}", this.name, this.nbRequest, this.failureRatio, this.requestsSeconds, this.children);
        }
    }
}

