/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gatling.plugin.model.RunAssertion;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.util.ObjectsUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class RunInformation {
    public final UUID runId;
    public final String scenario;
    public final long injectStart;
    public final RunStatus status;
    public final List<RunAssertion> assertions;

    @JsonCreator
    public RunInformation(@JsonProperty(value="runId", required=true) UUID uUID, @JsonProperty(value="scenario", required=true) String string, @JsonProperty(value="injectStart", required=true) long l, @JsonProperty(value="status", required=true) RunStatus runStatus, @JsonProperty(value="assertions", required=true) List<RunAssertion> list) {
        ObjectsUtil.nonNullParam(uUID, "runId");
        ObjectsUtil.nonNullParam(uUID, "scenario");
        ObjectsUtil.nonNullParam(runStatus, "status");
        ObjectsUtil.nonNullParam(list, "assertions");
        this.runId = uUID;
        this.scenario = string;
        this.injectStart = l;
        this.status = runStatus;
        this.assertions = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RunInformation runInformation = (RunInformation)object;
        return Objects.equals(this.runId, runInformation.runId) && Objects.equals(this.scenario, runInformation.scenario) && this.injectStart == runInformation.injectStart && Objects.equals((Object)this.status, (Object)runInformation.status) && Objects.equals(this.assertions, runInformation.assertions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.runId, this.scenario, this.injectStart, this.status, this.assertions});
    }

    public String toString() {
        return String.format("RunInformation{runId='%s',scenario='%s',injectStart='%s',status='%s',assertions='%s'}", new Object[]{this.runId, this.scenario, this.injectStart, this.status, this.assertions});
    }
}

