/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.Part;
import io.gatling.http.client.body.multipart.impl.MessageEndPartImpl;
import io.gatling.http.client.body.multipart.impl.MultipartChunkedInput;
import io.gatling.http.client.body.multipart.impl.MultipartFileRegion;
import io.gatling.http.client.body.multipart.impl.PartImpl;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartFormDataRequestBody
extends RequestBody<List<Part<?>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartFormDataRequestBody.class);
    private final byte[] boundary;

    MultipartFormDataRequestBody(List<Part<?>> list, String string, Charset charset, byte[] byArray) {
        super(list, string, charset);
        this.boundary = byArray;
    }

    @Override
    public WritableContent build(boolean bl, ByteBufAllocator byteBufAllocator) {
        ArrayList<PartImpl> arrayList = new ArrayList<PartImpl>(((List)this.content).size() + 1);
        for (Part part : (List)this.content) {
            arrayList.add(part.toImpl(this.boundary));
        }
        arrayList.add(new MessageEndPartImpl(this.boundary));
        long l = MultipartFormDataRequestBody.computeContentLength(arrayList);
        Object object = bl ? new MultipartFileRegion(arrayList, l) : new MultipartChunkedInput(arrayList, l);
        return new WritableContent(object, l);
    }

    @Override
    public RequestBodyBuilder<List<Part<?>>> newBuilder() {
        return new MultipartFormDataRequestBodyBuilder((List)this.content);
    }

    private static long computeContentLength(List<PartImpl> list) {
        try {
            long l = 0L;
            for (PartImpl partImpl : list) {
                long l2 = partImpl.length();
                if (l2 < 0L) {
                    return -1L;
                }
                l += l2;
            }
            return l;
        }
        catch (Exception exception) {
            LOGGER.error("An exception occurred while getting the length of the parts", (Throwable)exception);
            return 0L;
        }
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException("MultipartFormDataRequestBody#getBytes isn't implemented yet. Contributions welcome.");
    }

    public String toString() {
        return "MultipartFormDataRequestBody{boundary=" + Arrays.toString(this.boundary) + ", content=" + this.content + ", contentType=" + this.contentType + ", charset=" + this.charset + '}';
    }
}

