/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.netty.buffer.ByteBuf;

public interface PartVisitor {
    public void withBytes(byte[] var1);

    public void withByte(byte var1);

    public static class ByteBufVisitor
    implements PartVisitor {
        private final ByteBuf target;

        ByteBufVisitor(ByteBuf byteBuf) {
            this.target = byteBuf;
        }

        @Override
        public void withBytes(byte[] byArray) {
            this.target.writeBytes(byArray);
        }

        @Override
        public void withByte(byte by) {
            this.target.writeByte((int)by);
        }
    }

    public static class CounterPartVisitor
    implements PartVisitor {
        private int count = 0;

        @Override
        public void withBytes(byte[] byArray) {
            this.count += byArray.length;
        }

        @Override
        public void withByte(byte by) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

