/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.http;

import io.gatling.core.filter.AllowList;
import io.gatling.core.filter.DenyList;
import io.gatling.core.protocol.Protocol;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.response.Response;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Filter;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.http.Proxy;
import io.gatling.javaapi.http.internal.HttpChecks;
import io.gatling.javaapi.http.internal.HttpProtocolBuilders;
import io.gatling.javaapi.http.internal.ScalaHttpProtocolBuilderConditions;
import io.gatling.javaapi.http.internal.SignatureCalculators;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import org.jspecify.annotations.NonNull;
import scala.PartialFunction;

public final class HttpProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.http.protocol.HttpProtocolBuilder wrapped;

    public HttpProtocolBuilder(io.gatling.http.protocol.HttpProtocolBuilder httpProtocolBuilder) {
        this.wrapped = httpProtocolBuilder;
    }

    public Protocol protocol() {
        return this.wrapped.protocol();
    }

    public @NonNull HttpProtocolBuilder baseUrl(@NonNull String string) {
        return this.baseUrls(string);
    }

    public @NonNull HttpProtocolBuilder baseUrls(String ... stringArray) {
        return this.baseUrls(Arrays.asList(stringArray));
    }

    public @NonNull HttpProtocolBuilder baseUrls(@NonNull List<String> list) {
        return new HttpProtocolBuilder(this.wrapped.baseUrls(Converters.toScalaSeq(list)));
    }

    public @NonNull HttpProtocolBuilder warmUp(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.warmUp(string));
    }

    public @NonNull HttpProtocolBuilder disableWarmUp() {
        return new HttpProtocolBuilder(this.wrapped.disableWarmUp());
    }

    public @NonNull HttpProtocolBuilder shareConnections() {
        return new HttpProtocolBuilder(this.wrapped.shareConnections());
    }

    public @NonNull HttpProtocolBuilder localAddress(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.localAddress(string));
    }

    public @NonNull HttpProtocolBuilder localAddresses(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.localAddresses(Converters.toScalaSeq((Object)stringArray)));
    }

    public @NonNull HttpProtocolBuilder localAddresses(@NonNull List<String> list) {
        return new HttpProtocolBuilder(this.wrapped.localAddresses(Converters.toScalaSeq(list)));
    }

    public @NonNull HttpProtocolBuilder useAllLocalAddresses() {
        return new HttpProtocolBuilder(this.wrapped.useAllLocalAddresses());
    }

    public @NonNull HttpProtocolBuilder useAllLocalAddressesMatching(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.useAllLocalAddressesMatching(Converters.toScalaSeq((Object)stringArray)));
    }

    public @NonNull HttpProtocolBuilder maxConnectionsPerHost(int n) {
        return new HttpProtocolBuilder(this.wrapped.maxConnectionsPerHost(n));
    }

    public @NonNull HttpProtocolBuilder perUserKeyManagerFactory(@NonNull Function<Long, KeyManagerFactory> function) {
        return new HttpProtocolBuilder(this.wrapped.perUserKeyManagerFactory(object -> (KeyManagerFactory)function.apply((Long)object)));
    }

    public @NonNull HttpProtocolBuilder disableAutoReferer() {
        return new HttpProtocolBuilder(this.wrapped.disableAutoReferer());
    }

    public @NonNull HttpProtocolBuilder disableAutoOrigin() {
        return new HttpProtocolBuilder(this.wrapped.disableAutoOrigin());
    }

    public @NonNull HttpProtocolBuilder disableCaching() {
        return new HttpProtocolBuilder(this.wrapped.disableCaching());
    }

    public @NonNull HttpProtocolBuilder header(@NonNull CharSequence charSequence, @NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.header(charSequence, Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder header(@NonNull CharSequence charSequence, @NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.header(charSequence, Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder headers(Map<? extends CharSequence, String> map) {
        return new HttpProtocolBuilder(this.wrapped.headers(Converters.toScalaMap(map)));
    }

    public @NonNull HttpProtocolBuilder acceptHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder acceptHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder acceptCharsetHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptCharsetHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder acceptCharsetHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptCharsetHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder acceptEncodingHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptEncodingHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder acceptEncodingHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptEncodingHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder acceptLanguageHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptLanguageHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder acceptLanguageHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptLanguageHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder authorizationHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.authorizationHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder authorizationHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.authorizationHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder connectionHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.connectionHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder connectionHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.connectionHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder contentTypeHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.contentTypeHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder contentTypeHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.contentTypeHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder doNotTrackHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.doNotTrackHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder doNotTrackHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.doNotTrackHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder originHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.originHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder originHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.originHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder userAgentHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.userAgentHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder userAgentHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.userAgentHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder upgradeInsecureRequestsHeader(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.upgradeInsecureRequestsHeader(Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder upgradeInsecureRequestsHeader(@NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.upgradeInsecureRequestsHeader(Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder basicAuth(@NonNull String string, @NonNull String string2) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    public @NonNull HttpProtocolBuilder basicAuth(@NonNull String string, @NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder basicAuth(@NonNull Function<Session, String> function, @NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.javaFunctionToExpression(function), Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder basicAuth(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    public @NonNull HttpProtocolBuilder digestAuth(@NonNull String string, @NonNull String string2) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    public @NonNull HttpProtocolBuilder digestAuth(@NonNull String string, @NonNull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull HttpProtocolBuilder digestAuth(@NonNull Function<Session, String> function, @NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.javaFunctionToExpression(function), Expressions.toStringExpression((String)string)));
    }

    public @NonNull HttpProtocolBuilder digestAuth(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    public @NonNull HttpProtocolBuilder silentResources() {
        return new HttpProtocolBuilder(this.wrapped.silentResources());
    }

    public @NonNull HttpProtocolBuilder silentUri(@NonNull String string) {
        return new HttpProtocolBuilder(this.wrapped.silentUri(string));
    }

    public @NonNull HttpProtocolBuilder disableUrlEncoding() {
        return new HttpProtocolBuilder(this.wrapped.disableUrlEncoding());
    }

    public @NonNull HttpProtocolBuilder sign(@NonNull Function<Request, Request> function) {
        return this.sign((Request request, Session session) -> (Request)function.apply((Request)request));
    }

    public @NonNull HttpProtocolBuilder sign(@NonNull BiFunction<Request, Session, Request> biFunction) {
        return new HttpProtocolBuilder(this.wrapped.sign(SignatureCalculators.toScala(biFunction)));
    }

    public @NonNull HttpProtocolBuilder signWithOAuth1(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4) {
        return this.signWithOAuth1(string, string2, string3, string4, true);
    }

    public @NonNull HttpProtocolBuilder signWithOAuth1(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, boolean bl) {
        return new HttpProtocolBuilder(this.wrapped.signWithOAuth1(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2), Expressions.toStringExpression((String)string3), Expressions.toStringExpression((String)string4), bl));
    }

    public @NonNull HttpProtocolBuilder signWithOAuth1(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2, @NonNull Function<Session, String> function3, @NonNull Function<Session, String> function4) {
        return this.signWithOAuth1(function, function2, function3, function4, true);
    }

    public @NonNull HttpProtocolBuilder signWithOAuth1(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2, @NonNull Function<Session, String> function3, @NonNull Function<Session, String> function4, boolean bl) {
        return new HttpProtocolBuilder(this.wrapped.signWithOAuth1(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2), Expressions.javaFunctionToExpression(function3), Expressions.javaFunctionToExpression(function4), bl));
    }

    public HttpProtocolBuilder enableHttp2() {
        return new HttpProtocolBuilder(this.wrapped.enableHttp2());
    }

    public HttpProtocolBuilder http2PriorKnowledge(Map<String, Boolean> map) {
        return new HttpProtocolBuilder(this.wrapped.http2PriorKnowledge(Converters.toScalaMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))));
    }

    public HttpProtocolBuilder disableFollowRedirect() {
        return new HttpProtocolBuilder(this.wrapped.disableFollowRedirect());
    }

    public HttpProtocolBuilder maxRedirects(int n) {
        return new HttpProtocolBuilder(this.wrapped.maxRedirects(n));
    }

    public HttpProtocolBuilder strict302Handling() {
        return new HttpProtocolBuilder(this.wrapped.strict302Handling());
    }

    public HttpProtocolBuilder redirectNamingStrategy(RedirectNamingStrategy redirectNamingStrategy) {
        return new HttpProtocolBuilder(this.wrapped.redirectNamingStrategy((uri, string, object) -> redirectNamingStrategy.apply((Uri)uri, (String)string, (Integer)object)));
    }

    public HttpProtocolBuilder transformResponse(BiFunction<Response, Session, Response> biFunction) {
        return new HttpProtocolBuilder(this.wrapped.transformResponse(Expressions.javaBiFunctionToExpression(biFunction)));
    }

    public HttpProtocolBuilder check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    public HttpProtocolBuilder check(List<CheckBuilder> list) {
        return new HttpProtocolBuilder(this.wrapped.check(HttpChecks.toScalaChecks(list)));
    }

    public UntypedCondition checkIf(Function<Session, Boolean> function) {
        return new UntypedCondition(ScalaHttpProtocolBuilderConditions.untyped(this.wrapped, function));
    }

    public UntypedCondition checkIf(String string) {
        return new UntypedCondition(ScalaHttpProtocolBuilderConditions.untyped(this.wrapped, string));
    }

    public TypedCondition checkIf(BiFunction<Response, Session, Boolean> biFunction) {
        return new TypedCondition(ScalaHttpProtocolBuilderConditions.typed(this.wrapped, biFunction));
    }

    public HttpProtocolBuilder inferHtmlResources() {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources());
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.AllowList allowList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((AllowList)allowList.asScala()));
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.AllowList allowList, Filter.DenyList denyList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((AllowList)allowList.asScala(), (DenyList)denyList.asScala()));
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.DenyList denyList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((DenyList)denyList.asScala()));
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterUrlTail() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterUrlTail());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterAbsoluteUrl() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterAbsoluteUrl());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterRelativeUrl() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterRelativeUrl());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterPath() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterPath());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterLastPathElement() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterLastPathElement());
    }

    public HttpProtocolBuilder nameInferredHtmlResources(Function<Uri, String> function) {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResources(function::apply));
    }

    public HttpProtocolBuilder wsBaseUrl(String string) {
        return new HttpProtocolBuilder(this.wrapped.wsBaseUrl(string));
    }

    public HttpProtocolBuilder wsBaseUrls(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.wsBaseUrls(Converters.toScalaSeq((Object)stringArray)));
    }

    public HttpProtocolBuilder wsBaseUrls(List<String> list) {
        return new HttpProtocolBuilder(this.wrapped.wsBaseUrls(Converters.toScalaSeq(list)));
    }

    public HttpProtocolBuilder wsReconnect() {
        return new HttpProtocolBuilder(this.wrapped.wsReconnect());
    }

    public HttpProtocolBuilder wsMaxReconnects(int n) {
        return new HttpProtocolBuilder(this.wrapped.wsMaxReconnects(n));
    }

    public HttpProtocolBuilder wsAutoReplyTextFrame(final Function<String, String> function) {
        return new HttpProtocolBuilder(this.wrapped.wsAutoReplyTextFrame((PartialFunction)new PartialFunction<String, String>(){

            public boolean isDefinedAt(String string) {
                return function.apply(string) != null;
            }

            public String apply(String string) {
                return (String)function.apply(string);
            }
        }));
    }

    public HttpProtocolBuilder wsAutoReplySocketIo4() {
        return new HttpProtocolBuilder(this.wrapped.wsAutoReplySocketIo4());
    }

    public HttpProtocolBuilder wsUnmatchedInboundMessageBufferSize(int n) {
        return new HttpProtocolBuilder(this.wrapped.wsUnmatchedInboundMessageBufferSize(n));
    }

    public HttpProtocolBuilder sseUnmatchedInboundMessageBufferSize(int n) {
        return new HttpProtocolBuilder(this.wrapped.sseUnmatchedInboundMessageBufferSize(n));
    }

    public HttpProtocolBuilder proxy(Proxy proxy) {
        return new HttpProtocolBuilder(this.wrapped.proxy(proxy.asScala()));
    }

    public HttpProtocolBuilder noProxyFor(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.noProxyFor(Converters.toScalaSeq((Object)stringArray)));
    }

    public HttpProtocolBuilder proxyProtocolSourceIpV4Address(String string) {
        return new HttpProtocolBuilder(this.wrapped.proxyProtocolSourceIpV4Address(Expressions.toStringExpression((String)string)));
    }

    public HttpProtocolBuilder proxyProtocolSourceIpV4Address(Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.proxyProtocolSourceIpV4Address(Expressions.javaFunctionToExpression(function)));
    }

    public HttpProtocolBuilder proxyProtocolSourceIpV6Address(String string) {
        return new HttpProtocolBuilder(this.wrapped.proxyProtocolSourceIpV4Address(Expressions.toStringExpression((String)string)));
    }

    public HttpProtocolBuilder proxyProtocolSourceIpV6Address(Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.proxyProtocolSourceIpV4Address(Expressions.javaFunctionToExpression(function)));
    }

    public HttpProtocolBuilder asyncNameResolution(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.asyncNameResolution(Converters.toScalaSeq((Object)stringArray)));
    }

    public HttpProtocolBuilder asyncNameResolution(InetSocketAddress[] inetSocketAddressArray) {
        return new HttpProtocolBuilder(this.wrapped.asyncNameResolution(inetSocketAddressArray));
    }

    public HttpProtocolBuilder hostNameAliases(Map<String, List<String>> map) {
        return new HttpProtocolBuilder(this.wrapped.hostNameAliases(HttpProtocolBuilders.toScalaAliases(map)));
    }

    public HttpProtocolBuilder perUserNameResolution() {
        return new HttpProtocolBuilder(this.wrapped.perUserNameResolution());
    }

    @FunctionalInterface
    public static interface RedirectNamingStrategy {
        public String apply(Uri var1, String var2, int var3);
    }

    public static final class UntypedCondition {
        private final ScalaHttpProtocolBuilderConditions.Untyped wrapped;

        public UntypedCondition(ScalaHttpProtocolBuilderConditions.Untyped untyped) {
            this.wrapped = untyped;
        }

        public HttpProtocolBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        public HttpProtocolBuilder then(List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }

    public static final class TypedCondition {
        private final ScalaHttpProtocolBuilderConditions.Typed wrapped;

        public TypedCondition(ScalaHttpProtocolBuilderConditions.Typed typed) {
            this.wrapped = typed;
        }

        public HttpProtocolBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        public HttpProtocolBuilder then(List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }
}

