/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.check.body;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.check.extractor.jsonpath.JsonFilter;
import io.gatling.core.json.Boon$;
import io.gatling.core.json.Jackson$;
import io.gatling.core.json.JsonParser;
import io.gatling.core.session.Session;
import io.gatling.core.util.StringHelper;
import io.gatling.core.util.StringHelper$;
import io.gatling.core.validation.Validation;
import io.gatling.core.validation.package;
import io.gatling.core.validation.package$;
import io.gatling.http.check.body.HttpBodyJsonpJsonPathCheckBuilder;
import io.gatling.http.check.body.HttpBodyJsonpJsonPathCheckBuilder$;
import io.gatling.http.check.body.HttpBodyJsonpJsonPathOfType;
import io.gatling.http.check.body.HttpBodyJsonpJsonPathOfType$class;
import io.gatling.http.response.Response;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class HttpBodyJsonpJsonPathCheckBuilder$
implements StrictLogging {
    public static final HttpBodyJsonpJsonPathCheckBuilder$ MODULE$;
    private final Regex JsonpRegex;
    private final JsonParser JsonParser;
    private final Function1<Response, Validation<Object>> JsonpPreparer;
    private final Logger logger;

    static {
        new HttpBodyJsonpJsonPathCheckBuilder$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Regex JsonpRegex() {
        return this.JsonpRegex;
    }

    public JsonParser JsonParser() {
        return this.JsonParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Validation<Object> parseJsonpString(String string) {
        String string2 = string;
        Option option = this.JsonpRegex().unapplySeq((Object)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            Validation validation;
            String jsonp = (String)((LinearSeqOptimized)option.get()).apply(0);
            try {
                validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(this.JsonParser().parse(jsonp)));
                return validation;
            }
            catch (Exception exception) {
                String message2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse JSONP string into a JSON object: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()}));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(message2, (Throwable)exception);
                }
                validation = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(message2));
            }
            return validation;
        } else {
            String message = "Regex could not extract JSON object from JSONP response";
            if (!this.logger().underlying().isInfoEnabled()) return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(message));
            this.logger().underlying().info(message);
            return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(message));
        }
    }

    public Function1<Response, Validation<Object>> JsonpPreparer() {
        return this.JsonpPreparer;
    }

    public HttpBodyJsonpJsonPathCheckBuilder<String> jsonpJsonPath(Function1<Session, Validation<String>> path) {
        return new HttpBodyJsonpJsonPathOfType(path){

            public <X> HttpBodyJsonpJsonPathCheckBuilder<X> ofType(JsonFilter<X> evidence$1) {
                return HttpBodyJsonpJsonPathOfType$class.ofType(this, evidence$1);
            }
            {
                HttpBodyJsonpJsonPathOfType$class.$init$(this);
            }
        };
    }

    private HttpBodyJsonpJsonPathCheckBuilder$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.JsonpRegex = new StringOps(Predef$.MODULE$.augmentString("^\\w+(?:\\[\\\"\\w+\\\"\\]|\\.\\w+)*\\((.*)\\)$")).r();
        StringHelper.StringImplementation stringImplementation = StringHelper$.MODULE$.TheStringImplementation();
        StringHelper.DirectCharsBasedStringImplementation$ directCharsBasedStringImplementation$ = StringHelper.DirectCharsBasedStringImplementation$.MODULE$;
        StringHelper.StringImplementation stringImplementation2 = stringImplementation;
        Object object = !(directCharsBasedStringImplementation$ != null ? !directCharsBasedStringImplementation$.equals(stringImplementation2) : stringImplementation2 != null) ? Boon$.MODULE$ : Jackson$.MODULE$;
        this.JsonParser = object;
        this.JsonpPreparer = new anonfun.1();
    }
}

