/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.ning.http.client.uri.UriComponents;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.http.fetch.CssParser$;
import io.gatling.http.fetch.CssResource;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.util.HttpHelper$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class CssParser$
implements StrictLogging {
    public static final CssParser$ MODULE$;
    private final Regex InlineStyleImageUrls;
    private final Regex StyleImportsUrls;
    private final Some<Object> SingleQuoteEscapeChar;
    private final Some<Object> DoubleQuoteEscapeChar;
    private final char[] AtImportChars;
    private final char[] UrlStartChars;
    private final Logger logger;

    static {
        new CssParser$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Regex InlineStyleImageUrls() {
        return this.InlineStyleImageUrls;
    }

    public Regex StyleImportsUrls() {
        return this.StyleImportsUrls;
    }

    public Iterator<String> extractUrls(CharSequence string, Regex regex) {
        return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)regex.findAllIn(string).matchData().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(Regex.Match m) {
                String raw = m.group(1);
                return CssParser$.MODULE$.extractUrl(raw, 0, raw.length());
            }
        }), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Option<String> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        }).flatten();
    }

    public Some<Object> SingleQuoteEscapeChar() {
        return this.SingleQuoteEscapeChar;
    }

    public Some<Object> DoubleQuoteEscapeChar() {
        return this.DoubleQuoteEscapeChar;
    }

    public char[] AtImportChars() {
        return this.AtImportChars;
    }

    public char[] UrlStartChars() {
        return this.UrlStartChars;
    }

    public Option<String> extractUrl(String string, int start2, int end) {
        Object object;
        ObjectRef protectChar = new ObjectRef((Object)None$.MODULE$);
        BooleanRef broken = new BooleanRef(false);
        int trimmedStart = this.trimLeft$1(start2, string, protectChar, broken);
        int trimmedEnd = this.trimRight$1(end, string, protectChar, broken);
        if (broken.elem) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"css url ", " broken"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
            }
            object = None$.MODULE$;
        } else {
            object = string.charAt(trimmedStart) == '#' ? None$.MODULE$ : new Some((Object)string.substring(trimmedStart, trimmedEnd));
        }
        return object;
    }

    public List<EmbeddedResource> extractResources(UriComponents cssURI, String cssContent) {
        ArrayBuffer resources = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean withinComment = false;
        BooleanRef withinImport = new BooleanRef(false);
        BooleanRef withinUrl = new BooleanRef(false);
        int urlStart = 0;
        block6: for (int i = 0; i < cssContent.length(); ++i) {
            char c = cssContent.charAt(i);
            switch (c) {
                case ')': {
                    if (withinComment || !withinUrl.elem) continue block6;
                    this.extractUrl(cssContent, urlStart, i).foreach((Function1)new Serializable(cssURI, resources, withinImport, withinUrl){
                        public static final long serialVersionUID = 0L;
                        private final UriComponents cssURI$1;
                        public final ArrayBuffer resources$1;
                        public final BooleanRef withinImport$1;
                        public final BooleanRef withinUrl$1;

                        public final void apply(String url) {
                            HttpHelper$.MODULE$.resolveFromURISilently(this.cssURI$1, url).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.extractResources.1 $outer;

                                public final void apply(UriComponents absoluteUri) {
                                    this.$outer.resources$1.$plus$eq((Object)new CssResource(absoluteUri));
                                    this.$outer.withinUrl$1.elem = false;
                                    this.$outer.withinImport$1.elem = false;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.cssURI$1 = cssURI$1;
                            this.resources$1 = resources$1;
                            this.withinImport$1 = withinImport$1;
                            this.withinUrl$1 = withinUrl$1;
                        }
                    });
                    continue block6;
                }
                case 'u': {
                    if (withinComment || !withinImport.elem || !this.charsMatch$1(i, this.UrlStartChars(), cssContent)) continue block6;
                    urlStart = i += this.UrlStartChars().length;
                    withinUrl.elem = true;
                    continue block6;
                }
                case '@': {
                    if (withinComment || !this.charsMatch$1(i, this.AtImportChars(), cssContent)) continue block6;
                    withinImport.elem = true;
                    i += "@import".length();
                    continue block6;
                }
                case '/': {
                    if (i < cssContent.length() - 1 && cssContent.charAt(i + 1) == '*') {
                        withinComment = true;
                        ++i;
                        continue block6;
                    }
                    if (i <= 0 || cssContent.charAt(i - 1) != '*') continue block6;
                    withinComment = false;
                }
            }
        }
        return resources.toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int trimLeft$1(int cur, String string$1, ObjectRef protectChar$1, BooleanRef broken$1) {
        block5: while (true) {
            char c = string$1.charAt(cur);
            switch (c) {
                default: {
                    int n2 = cur;
                    return n2;
                }
                case '\"': {
                    int n;
                    Option option = (Option)protectChar$1.elem;
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        protectChar$1.elem = this.DoubleQuoteEscapeChar();
                        ++cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    int n2 = n = cur;
                    return n2;
                }
                case '\'': {
                    int n;
                    Option option = (Option)protectChar$1.elem;
                    None$ none$ = None$.MODULE$;
                    Option option3 = option;
                    if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                        protectChar$1.elem = this.SingleQuoteEscapeChar();
                        ++cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    int n2 = n = cur;
                    return n2;
                }
                case '\n': 
                case '\r': 
                case ' ': 
            }
            ++cur;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int trimRight$1(int cur, String string$1, ObjectRef protectChar$1, BooleanRef broken$1) {
        block5: while (true) {
            char c = string$1.charAt(cur - 1);
            switch (c) {
                default: {
                    int n2 = cur;
                    return n2;
                }
                case '\"': {
                    int n;
                    Option option = (Option)protectChar$1.elem;
                    Some<Object> some = this.DoubleQuoteEscapeChar();
                    Option option2 = option;
                    if (!(some != null ? !some.equals((Object)option2) : option2 != null)) {
                        --cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    int n2 = n = cur;
                    return n2;
                }
                case '\'': {
                    int n;
                    Option option = (Option)protectChar$1.elem;
                    Some<Object> some = this.SingleQuoteEscapeChar();
                    Option option3 = option;
                    if (!(some != null ? !some.equals((Object)option3) : option3 != null)) {
                        --cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    int n2 = n = cur;
                    return n2;
                }
                case '\n': 
                case '\r': 
                case ' ': 
            }
            --cur;
        }
    }

    private final boolean charsMatchRec$1(int j, String cssContent$1, int i$1, char[] chars$1) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    block3: {
                        if (j != chars$1.length) break block3;
                        bl = true;
                        break block4;
                    }
                    if (cssContent$1.charAt(i$1 + j) == chars$1[j]) break block5;
                    bl = false;
                }
                return bl;
            }
            ++j;
        }
    }

    private final boolean charsMatch$1(int i, char[] chars, String cssContent$1) {
        return i < cssContent$1.length() - chars.length && this.charsMatchRec$1(1, cssContent$1, i, chars);
    }

    private CssParser$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.InlineStyleImageUrls = new StringOps(Predef$.MODULE$.augmentString("url\\((.*)\\)")).r();
        this.StyleImportsUrls = new StringOps(Predef$.MODULE$.augmentString("@import.* url\\((.*)\\)")).r();
        this.SingleQuoteEscapeChar = new Some((Object)BoxesRunTime.boxToCharacter((char)'\''));
        this.DoubleQuoteEscapeChar = new Some((Object)BoxesRunTime.boxToCharacter((char)'\"'));
        this.AtImportChars = "@import".toCharArray();
        this.UrlStartChars = "url(".toCharArray();
    }
}

