/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.ning.http.client.Request;
import com.ning.http.client.uri.UriComponents;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.filter.Filters;
import io.gatling.core.session.Session;
import io.gatling.core.util.CacheHelper$;
import io.gatling.core.util.StringHelper;
import io.gatling.core.util.StringHelper$;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import io.gatling.http.action.RequestAction$;
import io.gatling.http.ahc.HttpTx;
import io.gatling.http.config.HttpProtocol;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.InferredPageResources;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.fetch.package$;
import io.gatling.http.fetch.package$EmbeddedResourcesFilters$;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ResourceFetcher$
implements StrictLogging {
    public static final ResourceFetcher$ MODULE$;
    private final scala.collection.concurrent.Map<UriComponents, List<EmbeddedResource>> CssContentCache;
    private final scala.collection.concurrent.Map<ResourceFetcher.InferredResourcesCacheKey, InferredPageResources> InferredResourcesCache;
    private final Logger logger;

    static {
        new ResourceFetcher$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public scala.collection.concurrent.Map<UriComponents, List<EmbeddedResource>> CssContentCache() {
        return this.CssContentCache;
    }

    public scala.collection.concurrent.Map<ResourceFetcher.InferredResourcesCacheKey, InferredPageResources> InferredResourcesCache() {
        return this.InferredResourcesCache;
    }

    public List<EmbeddedResource> io$gatling$http$fetch$ResourceFetcher$$applyResourceFilters(List<EmbeddedResource> resources, Option<Filters> filters) {
        List<EmbeddedResource> list;
        Option<Filters> option = filters;
        if (option instanceof Some) {
            Some some = (Some)option;
            Filters f = (Filters)some.x();
            list = package$EmbeddedResourcesFilters$.MODULE$.filter$extension(package$.MODULE$.EmbeddedResourcesFilters(f), resources);
        } else {
            list = resources;
        }
        return list;
    }

    public List<HttpRequest> io$gatling$http$fetch$ResourceFetcher$$resourcesToRequests(List<EmbeddedResource> resources, Session session, HttpProtocol protocol, boolean throttled) {
        return (List)resources.flatMap((Function1)new Serializable(session, protocol, throttled){
            public static final long serialVersionUID = 0L;
            private final Session session$1;
            private final HttpProtocol protocol$1;
            private final boolean throttled$1;

            public final Iterable<HttpRequest> apply(EmbeddedResource x$1) {
                Validation<HttpRequest> validation;
                block6: {
                    Iterable iterable;
                    block5: {
                        block4: {
                            validation = x$1.toRequest(this.session$1, this.protocol$1, this.throttled$1);
                            if (!(validation instanceof Success)) break block4;
                            Success success = (Success)validation;
                            HttpRequest httpRequest = (HttpRequest)success.value();
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                            break block5;
                        }
                        if (!(validation instanceof Failure)) break block6;
                        Failure failure = (Failure)validation;
                        String m = failure.message();
                        if (ResourceFetcher$.MODULE$.logger().underlying().isErrorEnabled()) {
                            ResourceFetcher$.MODULE$.logger().underlying().error(new StringBuilder().append((Object)"Could build request for embedded resource: ").append((Object)m).toString());
                        }
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError(validation);
            }
            {
                this.session$1 = session$1;
                this.protocol$1 = protocol$1;
                this.throttled$1 = throttled$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, HttpRequestConfig config) {
        block9: {
            htmlDocumentURI = response.request().getURI();
            protocol = config.protocol();
            var7_7 = false;
            var8_8 = null;
            var9_9 = response.statusCode();
            if (!(var9_9 instanceof Some)) ** GOTO lbl40
            var7_7 = true;
            var8_8 = (Some)var9_9;
            var10_10 = BoxesRunTime.unboxToInt((Object)var8_8.x());
            if (200 != var10_10) ** GOTO lbl40
            var12_11 = response.lastModifiedOrEtag(protocol);
            if (!(var12_11 instanceof Some)) break block9;
            var13_12 = (Some)var12_11;
            newLastModifiedOrEtag = (String)var13_12.x();
            cacheKey = new ResourceFetcher.InferredResourcesCacheKey(protocol, htmlDocumentURI);
            var17_15 = this.InferredResourcesCache().get((Object)cacheKey);
            if (!(var17_15 instanceof Some) || (var19_17 = (InferredPageResources)(var18_16 = (Some)var17_15).x()) == null) ** GOTO lbl-1000
            var20_18 = var19_17.expire();
            res = var19_17.requests();
            v0 = newLastModifiedOrEtag;
            var22_20 = var20_18;
            if (!(v0 != null ? v0.equals(var22_20) == false : var22_20 != null)) {
                var23_21 = res;
            } else lbl-1000:
            // 2 sources

            {
                inferredResources = this.inferredResourcesRequests$1(request, response, session, config, htmlDocumentURI, protocol);
                this.InferredResourcesCache().put((Object)cacheKey, (Object)new InferredPageResources(newLastModifiedOrEtag, inferredResources));
                var23_21 = inferredResources;
            }
            var15_23 = var23_21;
            ** GOTO lbl37
        }
        v1 = None$.MODULE$;
        var25_24 = var12_11;
        if (!(v1 != null ? v1.equals(var25_24) == false : var25_24 != null)) {
            var15_23 = this.inferredResourcesRequests$1(request, response, session, config, htmlDocumentURI, protocol);
lbl37:
            // 2 sources

            var11_25 = var15_23;
        } else {
            throw new MatchError(var12_11);
lbl40:
            // 2 sources

            if (var7_7 && 304 == (var26_26 = BoxesRunTime.unboxToInt((Object)var8_8.x()))) {
                var27_27 = this.InferredResourcesCache().get((Object)new ResourceFetcher.InferredResourcesCacheKey(protocol, htmlDocumentURI));
                if (var27_27 instanceof Some) {
                    var28_28 = (Some)var27_27;
                    inferredPageResources = (InferredPageResources)var28_28.x();
                    var30_30 = inferredPageResources.requests();
                } else {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got a 304 for ", " but could find cache entry?!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{htmlDocumentURI})));
                    }
                    var30_30 = Nil$.MODULE$;
                }
                var11_25 = var30_30;
            } else {
                var11_25 = Nil$.MODULE$;
            }
        }
        return var11_25;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return (List)resources.flatMap((Function1)new Serializable(session){
            public static final long serialVersionUID = 0L;
            private final Session session$3;

            public final Iterable<HttpRequest> apply(HttpRequestDef resource) {
                Validation validation;
                block9: {
                    Iterable iterable;
                    block8: {
                        block4: {
                            Validation<HttpRequest> validation2;
                            block7: {
                                Iterable iterable2;
                                block6: {
                                    String requestName;
                                    block5: {
                                        validation = (Validation)resource.requestName().apply((Object)this.session$3);
                                        if (!(validation instanceof Success)) break block4;
                                        Success success = (Success)validation;
                                        requestName = (String)success.value();
                                        validation2 = resource.build(requestName, this.session$3);
                                        if (!(validation2 instanceof Success)) break block5;
                                        Success success2 = (Success)validation2;
                                        HttpRequest httpRequest = (HttpRequest)success2.value();
                                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                                        break block6;
                                    }
                                    if (!(validation2 instanceof Failure)) break block7;
                                    Failure failure = (Failure)validation2;
                                    String m = failure.message();
                                    RequestAction$.MODULE$.reportUnbuildableRequest(requestName, this.session$3, m);
                                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                }
                                iterable = iterable2;
                                break block8;
                            }
                            throw new MatchError(validation2);
                        }
                        if (!(validation instanceof Failure)) break block9;
                        Failure failure = (Failure)validation;
                        String m = failure.message();
                        if (ResourceFetcher$.MODULE$.logger().underlying().isErrorEnabled()) {
                            ResourceFetcher$.MODULE$.logger().underlying().error(new StringBuilder().append((Object)"Could build request name for explicitResource: ").append((Object)m).toString());
                        }
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError((Object)validation);
            }
            {
                this.session$3 = session$3;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<Function0<ResourceFetcher>> resourceFetcher(HttpTx tx, List<HttpRequest> inferredResources, List<HttpRequest> explicitResources) {
        List<HttpRequest> list = inferredResources;
        Map uniqueResources = (Map)explicitResources.$colon$colon$colon(list).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<UriComponents, HttpRequest> apply(HttpRequest res) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)res.ahcRequest().getURI()), (Object)res);
            }
        }, scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        return uniqueResources.isEmpty() ? None$.MODULE$ : new Some((Object)new Serializable(tx, uniqueResources){
            public static final long serialVersionUID = 0L;
            private final HttpTx tx$1;
            private final Map uniqueResources$1;

            public final ResourceFetcher apply() {
                return new ResourceFetcher(this.tx$1, (Seq<HttpRequest>)this.uniqueResources$1.values().toSeq());
            }
            {
                this.tx$1 = tx$1;
                this.uniqueResources$1 = uniqueResources$1;
            }
        });
    }

    public Option<Function0<ResourceFetcher>> resourceFetcherForCachedPage(UriComponents htmlDocumentURI, HttpTx tx) {
        Option option;
        block4: {
            List<HttpRequest> list;
            block3: {
                block2: {
                    option = this.InferredResourcesCache().get((Object)new ResourceFetcher.InferredResourcesCacheKey(tx.request().config().protocol(), htmlDocumentURI));
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    list = Nil$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                InferredPageResources resources = (InferredPageResources)some.x();
                list = resources.requests();
            }
            List<HttpRequest> inferredResources = list;
            List<HttpRequest> explicitResources = this.buildExplicitResources(tx.request().config().explicitResources(), tx.session());
            return this.resourceFetcher(tx, inferredResources, explicitResources);
        }
        throw new MatchError((Object)option);
    }

    public Option<Function0<ResourceFetcher>> resourceFetcherForFetchedPage(Request request, Response response, HttpTx tx) {
        HttpProtocol protocol = tx.request().config().protocol();
        List<HttpRequest> explicitResources = tx.request().config().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().config().explicitResources(), tx.session()) : Nil$.MODULE$;
        List<HttpRequest> inferredResources = protocol.responsePart().inferHtmlResources() && response.isReceived() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(request, response, tx.session(), tx.request().config()) : Nil$.MODULE$;
        return this.resourceFetcher(tx, inferredResources, explicitResources);
    }

    private final List inferredResourcesRequests$1(Request request$1, Response response$1, Session session$2, HttpRequestConfig config$1, UriComponents htmlDocumentURI$1, HttpProtocol protocol$2) {
        List<EmbeddedResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentURI$1, StringHelper.RichString$.MODULE$.unsafeChars$extension(StringHelper$.MODULE$.RichString(response$1.body().string())), UserAgent$.MODULE$.getAgent(request$1));
        List<EmbeddedResource> filtered = this.io$gatling$http$fetch$ResourceFetcher$$applyResourceFilters(inferred, protocol$2.responsePart().htmlResourcesInferringFilters());
        return this.io$gatling$http$fetch$ResourceFetcher$$resourcesToRequests(filtered, session$2, protocol$2, config$1.throttled());
    }

    private ResourceFetcher$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.CssContentCache = CacheHelper$.MODULE$.newCache(GatlingConfiguration$.MODULE$.configuration().http().fetchedCssCacheMaxCapacity());
        this.InferredResourcesCache = CacheHelper$.MODULE$.newCache(GatlingConfiguration$.MODULE$.configuration().http().fetchedHtmlCacheMaxCapacity());
    }
}

