/**
 * Copyright 2011-2015 eBusiness Information, Groupe Excilys (www.ebusinessinformation.fr)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gatling.http.request.builder.ws

import com.ning.http.client.Request
import io.gatling.core.config.GatlingConfiguration
import io.gatling.core.session.Expression
import io.gatling.http.action.ws.WsOpenActionBuilder
import io.gatling.http.ahc.HttpEngine
import io.gatling.http.cache.HttpCaches
import io.gatling.http.config.{ DefaultHttpProtocol, HttpProtocol }
import io.gatling.http.request.builder.{ RequestBuilder, CommonAttributes }

object WsOpenRequestBuilder {

  implicit def toActionBuilder(requestBuilder: WsOpenRequestBuilder)(implicit configuration: GatlingConfiguration, defaultHttpProtocol: DefaultHttpProtocol, httpEngine: HttpEngine) =
    new WsOpenActionBuilder(requestBuilder.commonAttributes.requestName, requestBuilder.wsName, requestBuilder)
}

case class WsOpenRequestBuilder(commonAttributes: CommonAttributes, wsName: String)(implicit configuration: GatlingConfiguration, httpCaches: HttpCaches)
    extends RequestBuilder[WsOpenRequestBuilder] {

  private[http] def newInstance(commonAttributes: CommonAttributes) = new WsOpenRequestBuilder(commonAttributes, wsName)

  def build(protocol: HttpProtocol): Expression[Request] = new WsRequestExpressionBuilder(commonAttributes, protocol).build
}
