/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.ning.http.client.cookie.RFC2616DateParser;
import io.gatling.core.util.NumberHelper$;
import io.gatling.core.util.TimeHelper$;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.cache.ExpiresSupport;
import io.gatling.http.response.Response;
import java.text.ParsePosition;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public abstract class ExpiresSupport$class {
    public static Option extractMaxAgeValue(ExpiresSupport $this, String s) {
        None$ none$;
        int index = s.indexOf($this.MaxAgePrefix());
        int start2 = $this.MaxAgePrefix().length() + index;
        if (index >= 0 && start2 <= s.length()) {
            char c = s.charAt(start2);
            switch (c) {
                default: {
                    if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)NumberHelper$.MODULE$.extractLongValue(s, start2)));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                case '-': {
                    none$ = new Some((Object)BoxesRunTime.boxToLong((long)-1L));
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static Option extractExpiresValue(ExpiresSupport $this, String timestring) {
        String trimmedTimeString = ExpiresSupport$class.removeQuote$1($this, timestring.trim());
        return Option$.MODULE$.apply((Object)RFC2616DateParser.get().parse(trimmedTimeString, new ParsePosition(0))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(Date x$1) {
                return x$1.getTime();
            }
        });
    }

    public static Option getResponseExpires(ExpiresSupport $this, Response response) {
        return ExpiresSupport$class.pragmaNoCache$1($this, response) || ExpiresSupport$class.cacheControlNoCache$1($this, response) ? None$.MODULE$ : ExpiresSupport$class.maxAgeAsExpiresValue$1($this, response).orElse((Function0)new Serializable($this, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpiresSupport $outer;
            private final Response response$1;

            public final Option<Object> apply() {
                return ExpiresSupport$class.expiresValue$1(this.$outer, this.response$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.response$1 = response$1;
            }
        }).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$4) {
                return this.apply$mcZJ$sp(x$4);
            }

            public boolean apply$mcZJ$sp(long x$4) {
                return x$4 > 0L;
            }
        });
    }

    private static final String removeQuote$1(ExpiresSupport $this, String s) {
        String string;
        if (s.isEmpty()) {
            string = s;
        } else {
            int start2 = 0;
            int end = s.length();
            if (s.charAt(0) == '\"') {
                ++start2;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                --end;
            }
            string = s.substring(start2, end);
        }
        return string;
    }

    private static final boolean pragmaNoCache$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Pragma()).exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains(HeaderValues$.MODULE$.NoCache());
            }
        });
    }

    private static final boolean cacheControlNoCache$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpiresSupport $outer;

            public final boolean apply(String h) {
                return h.contains(HeaderValues$.MODULE$.NoCache()) || h.contains(HeaderValues$.MODULE$.NoStore()) || h.contains(this.$outer.MaxAgeZero());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static final Option maxAgeAsExpiresValue$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpiresSupport $outer;

            public final Option<Object> apply(String s) {
                return this.$outer.extractMaxAgeValue(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(long maxAge) {
                return this.apply$mcJJ$sp(maxAge);
            }

            public long apply$mcJJ$sp(long maxAge) {
                return maxAge < 0L ? maxAge : maxAge * 1000L + TimeHelper$.MODULE$.nowMillis();
            }
        });
    }

    public static final Option expiresValue$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Expires()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpiresSupport $outer;

            public final Option<Object> apply(String timestring) {
                return this.$outer.extractExpiresValue(timestring);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return x$3 > TimeHelper$.MODULE$.nowMillis();
            }
        });
    }

    public static void $init$(ExpiresSupport $this) {
        $this.io$gatling$http$cache$ExpiresSupport$_setter_$MaxAgePrefix_$eq("max-age=");
        $this.io$gatling$http$cache$ExpiresSupport$_setter_$MaxAgeZero_$eq(new StringBuilder().append((Object)$this.MaxAgePrefix()).append((Object)"0").toString());
    }
}

