/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.Param;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import com.ning.http.client.uri.Uri;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.CompositeByteArrayBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.RawFileBody$;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.validation.Validation;
import io.gatling.core.validation.package;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.config.HttpProtocol;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpParam;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.package$;
import io.gatling.http.request.builder.package$HttpParams$;
import io.gatling.http.util.HttpHelper$;
import java.io.File;
import java.io.InputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u0011A\u0004\u0013;uaJ+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\u0004\t\u00059!-^5mI\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0011X-];fgRT!a\u0002\u0005\u0002\t!$H\u000f\u001d\u0006\u0003\u0013)\tqaZ1uY&twMC\u0001\f\u0003\tIwn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005a\u0011V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005\u00012m\\7n_:\fE\u000f\u001e:jEV$Xm\u001d\t\u0003\u001fUI!A\u0006\u0002\u0003!\r{W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\b\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u001d!$H\u000f]!uiJL'-\u001e;fgB\u0011qBG\u0005\u00037\t\u0011a\u0002\u0013;ua\u0006#HO]5ckR,7\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003!\u0001(o\u001c;pG>d\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0007\u0003\u0019\u0019wN\u001c4jO&\u00111\u0005\t\u0002\r\u0011R$\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0005\tK\u0001\u0011\t\u0011)A\u0006M\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"aJ\u0016\u000e\u0003!R!!I\u0015\u000b\u0005)B\u0011\u0001B2pe\u0016L!\u0001\f\u0015\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0011!q\u0003A!A!\u0002\u0017y\u0013A\u00035uiB\u001c\u0015m\u00195fgB\u0011\u0001gM\u0007\u0002c)\u0011!GB\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0003iE\u0012!\u0002\u0013;ua\u000e\u000b7\r[3t\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q!\u0001\bP\u001f?)\rI$h\u000f\t\u0003\u001f\u0001AQ!J\u001bA\u0004\u0019BQAL\u001bA\u0004=BQaE\u001bA\u0002QAQ\u0001G\u001bA\u0002eAQ!H\u001bA\u0002yAQ\u0001\u0011\u0001\u0005\u0002\u0005\u000bA\"\\1lK\u0006\u00137o\u001c7vi\u0016$\"A\u0011*\u0011\u0007\r3\u0005*D\u0001E\u0015\t)\u0015&\u0001\u0006wC2LG-\u0019;j_:L!a\u0012#\u0003\u0015Y\u000bG.\u001b3bi&|g\u000e\u0005\u0002J\u001f:\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\u00061\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq5\nC\u0003T\u007f\u0001\u0007\u0001*A\u0002ve2DQ!\u0016\u0001\u0005\u0002Y\u000bqbY8oM&<WO]3DC\u000eDWm\u001d\u000b\u0004/\u001alGC\u0001-e!\r\u0019e)\u0017\t\u00035\nl\u0011a\u0017\u0006\u00039v\u000baa\u00197jK:$(BA\u0004_\u0015\ty\u0006-\u0001\u0003oS:<'\"A1\u0002\u0007\r|W.\u0003\u0002d7\nq!+Z9vKN$()^5mI\u0016\u0014\b\"B3U\u0001\u0004I\u0016A\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\u0005\u0006OR\u0003\r\u0001[\u0001\bg\u0016\u001c8/[8o!\tI7.D\u0001k\u0015\t9\u0017&\u0003\u0002mU\n91+Z:tS>t\u0007\"\u00028U\u0001\u0004y\u0017aA;sSB\u0011\u0001O]\u0007\u0002c*\u0011anW\u0005\u0003gF\u00141!\u0016:j\u0011\u0015)\b\u0001\"\u0001w\u0003M\u0019wN\u001c4jOV\u0014XMR8s[B\u000b'/Y7t)\t9\u0018\u0010\u0006\u0002Yq\")Q\r\u001ea\u00013\")q\r\u001ea\u0001Q\")1\u0010\u0001C\u0001y\u0006q1m\u001c8gS\u001e,(/\u001a)beR\u001cHCA?\u0000)\tAf\u0010C\u0003fu\u0002\u0007\u0011\fC\u0003hu\u0002\u0007\u0001\u000eC\u0004\u0002\u0004\u0001!\t&!\u0002\u0002/\r|gNZ5hkJ,'+Z9vKN$()^5mI\u0016\u0014Hc\u0002-\u0002\b\u0005%\u00111\u0002\u0005\u0007O\u0006\u0005\u0001\u0019\u00015\t\r9\f\t\u00011\u0001p\u0011\u0019)\u0017\u0011\u0001a\u00013\u0002")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final CommonAttributes commonAttributes;
    private final HttpAttributes httpAttributes;
    private final HttpProtocol protocol;
    public final GatlingConfiguration io$gatling$http$request$builder$HttpRequestExpressionBuilder$$configuration;
    private final HttpCaches httpCaches;

    @Override
    public Validation<String> makeAbsolute(String url) {
        Validation validation;
        if (HttpHelper$.MODULE$.isAbsoluteHttpUrl(url)) {
            validation = package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)url));
        } else {
            Validation validation2;
            Option<String> option = this.protocol.baseURL();
            if (option instanceof Some) {
                Some some = (Some)option;
                String baseURL = (String)some.x();
                validation2 = package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)new StringBuilder().append((Object)baseURL).append((Object)url).toString()));
            } else {
                validation2 = package.FailureWrapper$.MODULE$.failure$extension(io.gatling.core.validation.package$.MODULE$.FailureWrapper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No protocol.baseURL defined but provided url is relative : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url}))));
            }
            validation = validation2;
        }
        return validation;
    }

    public Validation<RequestBuilder> configureCaches(Session session, Uri uri2, RequestBuilder requestBuilder) {
        this.httpCaches.contentCacheEntry(session, uri2, this.commonAttributes.method()).foreach((Function1)new Serializable(this, requestBuilder){
            public static final long serialVersionUID = 0L;
            public final RequestBuilder requestBuilder$1;

            public final void apply(ContentCacheEntry x0$1) {
                ContentCacheEntry contentCacheEntry = x0$1;
                if (contentCacheEntry != null) {
                    Option<String> etag = contentCacheEntry.etag();
                    Option<String> lastModified = contentCacheEntry.lastModified();
                    etag.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$configureCaches$1 $outer;

                        public final RequestBuilder apply(String x$1) {
                            return this.$outer.requestBuilder$1.setHeader(HeaderNames$.MODULE$.IfModifiedSince(), x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    lastModified.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$configureCaches$1 $outer;

                        public final RequestBuilder apply(String x$2) {
                            return this.$outer.requestBuilder$1.setHeader(HeaderNames$.MODULE$.IfNoneMatch(), x$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)contentCacheEntry);
            }
            {
                this.requestBuilder$1 = requestBuilder$1;
            }
        });
        return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder));
    }

    public Validation<RequestBuilder> configureFormParams(Session session, RequestBuilder requestBuilder) {
        List<BodyPart> list = this.httpAttributes.bodyParts();
        Validation validation = Nil$.MODULE$.equals(list) ? this.configureFormParamsAsParams$1(session, requestBuilder) : this.configureFormParamsAsStringParts$1(session, requestBuilder);
        return validation;
    }

    public Validation<RequestBuilder> configureParts(Session session, RequestBuilder requestBuilder) {
        Option<Body> option;
        block4: {
            Validation validation;
            block3: {
                block2: {
                    Predef$.MODULE$.require(!this.httpAttributes.body().isDefined() || this.httpAttributes.bodyParts().isEmpty(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Can't have both a body and body parts!";
                        }
                    });
                    option = this.httpAttributes.body();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Body body = (Body)some.x();
                    validation = this.setBody$1(body, session, requestBuilder);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                List<BodyPart> list = this.httpAttributes.bodyParts();
                Validation validation2 = Nil$.MODULE$.equals(list) ? package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder)) : this.setBodyParts$1(list, session, requestBuilder);
                validation = validation2;
            }
            return validation;
        }
        throw new MatchError(option);
    }

    @Override
    public Validation<RequestBuilder> configureRequestBuilder(Session session, Uri uri2, RequestBuilder requestBuilder) {
        return super.configureRequestBuilder(session, uri2, requestBuilder).flatMap((Function1)new Serializable(this, session, uri2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpRequestExpressionBuilder $outer;
            private final Session session$3;
            private final Uri uri$1;

            public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                return this.$outer.configureCaches(this.session$3, this.uri$1, requestBuilder);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
                this.uri$1 = uri$1;
            }
        }).flatMap((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpRequestExpressionBuilder $outer;
            private final Session session$3;

            public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                return this.$outer.configureFormParams(this.session$3, requestBuilder);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
            }
        }).flatMap((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpRequestExpressionBuilder $outer;
            private final Session session$3;

            public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                return this.$outer.configureParts(this.session$3, requestBuilder);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
            }
        });
    }

    private final Validation configureFormParamsAsParams$1(Session session$1, RequestBuilder requestBuilder$2) {
        List<HttpParam> list = this.httpAttributes.formParams();
        Validation validation = Nil$.MODULE$.equals(list) ? package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder$2)) : package$HttpParams$.MODULE$.resolveParamJList$extension(package$.MODULE$.HttpParams(list), session$1).map((Function1)new Serializable(this, requestBuilder$2){
            public static final long serialVersionUID = 0L;
            private final RequestBuilder requestBuilder$2;

            public final RequestBuilder apply(java.util.List<Param> x$1) {
                return this.requestBuilder$2.setFormParams(x$1);
            }
            {
                this.requestBuilder$2 = requestBuilder$2;
            }
        });
        return validation;
    }

    private final Validation configureFormParamsAsStringParts$1(Session session$1, RequestBuilder requestBuilder$2) {
        return package$HttpParams$.MODULE$.resolveParamJList$extension(package$.MODULE$.HttpParams(this.httpAttributes.formParams()), session$1).map((Function1)new Serializable(this, requestBuilder$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpRequestExpressionBuilder $outer;
            public final RequestBuilder requestBuilder$2;

            public final RequestBuilder apply(java.util.List<Param> params) {
                JavaConversions$.MODULE$.asScalaBuffer(params).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$configureFormParamsAsStringParts$1$1 $outer;

                    public final RequestBuilder apply(Param param) {
                        return this.$outer.requestBuilder$2.addBodyPart((Part)new StringPart(param.getName(), param.getValue(), null, this.$outer.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$anonfun$$$outer().io$gatling$http$request$builder$HttpRequestExpressionBuilder$$configuration.core().charset()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return this.requestBuilder$2;
            }

            public /* synthetic */ HttpRequestExpressionBuilder io$gatling$http$request$builder$HttpRequestExpressionBuilder$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestBuilder$2 = requestBuilder$2;
            }
        });
    }

    private final Validation setBody$1(Body body, Session session$2, RequestBuilder requestBuilder$3) {
        Body body2;
        block7: {
            Validation validation;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            RawFileBody rawFileBody;
                            Some some;
                            block2: {
                                body2 = body;
                                if (!(body2 instanceof StringBody)) break block2;
                                StringBody stringBody = (StringBody)body2;
                                Function1 string = stringBody.string();
                                validation = ((Validation)string.apply((Object)session$2)).map((Function1)new Serializable(this, requestBuilder$3){
                                    public static final long serialVersionUID = 0L;
                                    private final RequestBuilder requestBuilder$3;

                                    public final RequestBuilder apply(String x$1) {
                                        return this.requestBuilder$3.setBody(x$1);
                                    }
                                    {
                                        this.requestBuilder$3 = requestBuilder$3;
                                    }
                                });
                                break block3;
                            }
                            if (!(body2 instanceof RawFileBody) || (some = RawFileBody$.MODULE$.unapply(rawFileBody = (RawFileBody)body2)).isEmpty()) break block4;
                            Function1 file = (Function1)some.get();
                            validation = ((Validation)file.apply((Object)session$2)).map((Function1)new Serializable(this, requestBuilder$3){
                                public static final long serialVersionUID = 0L;
                                private final RequestBuilder requestBuilder$3;

                                public final RequestBuilder apply(File x$1) {
                                    return (RequestBuilder)this.requestBuilder$3.setBody(x$1);
                                }
                                {
                                    this.requestBuilder$3 = requestBuilder$3;
                                }
                            });
                            break block3;
                        }
                        if (!(body2 instanceof ByteArrayBody)) break block5;
                        ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
                        Function1 bytes = byteArrayBody.bytes();
                        validation = ((Validation)bytes.apply((Object)session$2)).map((Function1)new Serializable(this, requestBuilder$3){
                            public static final long serialVersionUID = 0L;
                            private final RequestBuilder requestBuilder$3;

                            public final RequestBuilder apply(byte[] x$1) {
                                return this.requestBuilder$3.setBody(x$1);
                            }
                            {
                                this.requestBuilder$3 = requestBuilder$3;
                            }
                        });
                        break block3;
                    }
                    if (!(body2 instanceof CompositeByteArrayBody)) break block6;
                    CompositeByteArrayBody compositeByteArrayBody = (CompositeByteArrayBody)body2;
                    Function1 bytes = compositeByteArrayBody.bytes();
                    validation = ((Validation)bytes.apply((Object)session$2)).map((Function1)new Serializable(this, requestBuilder$3){
                        public static final long serialVersionUID = 0L;
                        private final RequestBuilder requestBuilder$3;

                        public final RequestBuilder apply(Seq<byte[]> bs) {
                            return (RequestBuilder)this.requestBuilder$3.setBody(JavaConversions$.MODULE$.seqAsJavaList(bs));
                        }
                        {
                            this.requestBuilder$3 = requestBuilder$3;
                        }
                    });
                    break block3;
                }
                if (!(body2 instanceof InputStreamBody)) break block7;
                InputStreamBody inputStreamBody = (InputStreamBody)body2;
                Function1 is = inputStreamBody.is();
                validation = ((Validation)is.apply((Object)session$2)).map((Function1)new Serializable(this, requestBuilder$3){
                    public static final long serialVersionUID = 0L;
                    private final RequestBuilder requestBuilder$3;

                    public final RequestBuilder apply(InputStream is) {
                        return (RequestBuilder)this.requestBuilder$3.setBody((BodyGenerator)new InputStreamBodyGenerator(is));
                    }
                    {
                        this.requestBuilder$3 = requestBuilder$3;
                    }
                });
            }
            return validation;
        }
        throw new MatchError((Object)body2);
    }

    private final Validation setBodyParts$1(List bodyParts, Session session$2, RequestBuilder requestBuilder$3) {
        Object object = this.commonAttributes.headers().contains((Object)HeaderNames$.MODULE$.ContentType()) ? BoxedUnit.UNIT : requestBuilder$3.addHeader(HeaderNames$.MODULE$.ContentType(), HeaderValues$.MODULE$.MultipartFormData());
        return (Validation)bodyParts.foldLeft((Object)package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder$3)), (Function2)new Serializable(this, session$2){
            public static final long serialVersionUID = 0L;
            public final Session session$2;

            public final Validation<RequestBuilder> apply(Validation<RequestBuilder> requestBuilder, BodyPart part) {
                return requestBuilder.flatMap((Function1)new Serializable(this, part){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$setBodyParts$1$1 $outer;
                    private final BodyPart part$1;

                    public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                        return this.part$1.toMultiPart(this.$outer.session$2).map((Function1)new Serializable(this, requestBuilder){
                            public static final long serialVersionUID = 0L;
                            private final RequestBuilder requestBuilder$4;

                            public final RequestBuilder apply(Part part) {
                                return this.requestBuilder$4.addBodyPart(part);
                            }
                            {
                                this.requestBuilder$4 = requestBuilder$4;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.part$1 = part$1;
                    }
                });
            }
            {
                this.session$2 = session$2;
            }
        });
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpProtocol protocol, GatlingConfiguration configuration, HttpCaches httpCaches) {
        this.commonAttributes = commonAttributes;
        this.httpAttributes = httpAttributes;
        this.protocol = protocol;
        this.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$configuration = configuration;
        this.httpCaches = httpCaches;
        super(commonAttributes, protocol, configuration, httpCaches);
    }
}

