/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import akka.actor.ActorSystem;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.SystemProps$;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.impl.DefaultHttpClient;
import io.gatling.http.engine.EventLoopGroups;
import io.gatling.http.engine.HttpClientFactory;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import javax.net.ssl.KeyManagerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M3Q\u0001C\u0005\u0001\u001bEA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)\u0001\b\u0001C\u0001s!9Q\b\u0001b\u0001\n\u0013q\u0004BB#\u0001A\u0003%q\b\u0003\u0004G\u0001\u0011\u0005Qb\u0012\u0005\u0006\u001d\u0002!\te\u0014\u0002\u0019\t\u00164\u0017-\u001e7u\u0011R$\bo\u00117jK:$h)Y2u_JL(B\u0001\u0006\f\u0003\u0019)gnZ5oK*\u0011A\"D\u0001\u0005QR$\bO\u0003\u0002\u000f\u001f\u00059q-\u0019;mS:<'\"\u0001\t\u0002\u0005%|7#\u0002\u0001\u00131qy\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\t\u0011\"\u0003\u0002\u001c\u0013\t\t\u0002\n\u001e;q\u00072LWM\u001c;GC\u000e$xN]=\u0011\u0005ei\u0012B\u0001\u0010\n\u0005=)e/\u001a8u\u0019>|\u0007o\u0012:pkB\u001c\bC\u0001\u0011(\u001b\u0005\t#B\u0001\u0012$\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t!S%\u0001\u0005usB,7/\u00194f\u0015\u00051\u0013aA2p[&\u0011\u0001&\t\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u001d\r|'/Z\"p[B|g.\u001a8ug\u000e\u0001\u0001C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u000e\u0003\u0011\u0019wN]3\n\u0005Aj#AD\"pe\u0016\u001cu.\u001c9p]\u0016tGo]\u0001\u0013gNd7i\u001c8uKb$8OR1di>\u0014\u0018\u0010\u0005\u00024m5\tAG\u0003\u00026\u0017\u0005!Q\u000f^5m\u0013\t9DG\u0001\nTg2\u001cuN\u001c;fqR\u001ch)Y2u_JL\u0018A\u0002\u001fj]&$h\bF\u0002;wq\u0002\"!\u0007\u0001\t\u000b%\u001a\u0001\u0019A\u0016\t\u000bE\u001a\u0001\u0019\u0001\u001a\u0002\u0015!$H\u000f]\"p]\u001aLw-F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011U&\u0001\u0004d_:4\u0017nZ\u0005\u0003\t\u0006\u0013\u0011\u0003\u0013;ua\u000e{gNZ5hkJ\fG/[8o\u0003-AG\u000f\u001e9D_:4\u0017n\u001a\u0011\u0002\u001f9,wo\u00117jK:$8i\u001c8gS\u001e$\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017.\taa\u00197jK:$\u0018BA'K\u0005AAE\u000f\u001e9DY&,g\u000e^\"p]\u001aLw-A\u0005oK^\u001cE.[3oiV\t\u0001\u000b\u0005\u0002J#&\u0011!K\u0013\u0002\u000b\u0011R$\bo\u00117jK:$\b")
public class DefaultHttpClientFactory
implements HttpClientFactory,
EventLoopGroups,
StrictLogging {
    private final CoreComponents coreComponents;
    private final SslContextsFactory sslContextsFactory;
    private final HttpConfiguration httpConfig;
    private final Logger logger;

    @Override
    public EventLoopGroup newEventLoopGroup(ActorSystem system, String poolName, boolean useNativeTransport) {
        return EventLoopGroups.newEventLoopGroup$(this, system, poolName, useNativeTransport);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private HttpConfiguration httpConfig() {
        return this.httpConfig;
    }

    public HttpClientConfig newClientConfig() {
        SslContexts sslContexts = this.sslContextsFactory.newSslContexts(true, (Option<KeyManagerFactory>)None$.MODULE$);
        if (sslContexts == null) {
            throw new MatchError((Object)sslContexts);
        }
        SslContext defaultSslContext = sslContexts.sslContext();
        Option<SslContext> defaultAlpnSslContext = sslContexts.alplnSslContext();
        Tuple2 tuple2 = new Tuple2((Object)defaultSslContext, defaultAlpnSslContext);
        Tuple2 tuple22 = tuple2;
        SslContext defaultSslContext2 = (SslContext)tuple22._1();
        Option defaultAlpnSslContext2 = (Option)tuple22._2();
        return new HttpClientConfig().setDefaultSslContext(defaultSslContext2).setDefaultAlpnSslContext((SslContext)defaultAlpnSslContext2.orNull(Predef$.MODULE$.$conforms())).setConnectTimeout(this.httpConfig().advanced().connectTimeout().toMillis()).setHandshakeTimeout(this.httpConfig().advanced().handshakeTimeout().toMillis()).setChannelPoolIdleTimeout(this.httpConfig().advanced().pooledConnectionIdleTimeout().toMillis()).setMaxRetry(this.httpConfig().advanced().maxRetry()).setEnableSni(this.httpConfig().advanced().enableSni()).setEnableHostnameVerification(this.httpConfig().advanced().enableHostnameVerification()).setDefaultCharset(this.coreComponents.configuration().core().charset()).setUseNativeTransport(this.httpConfig().advanced().useNativeTransport()).setTcpNoDelay(this.httpConfig().advanced().tcpNoDelay()).setSoReuseAddress(this.httpConfig().advanced().soReuseAddress()).setEnableZeroCopy(this.httpConfig().advanced().enableZeroCopy()).setThreadPoolName("gatling-http");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpClient newClient() {
        void var1_1;
        DefaultHttpClient client = new DefaultHttpClient(this.newClientConfig());
        this.coreComponents.actorSystem().registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> client.close());
        return var1_1;
    }

    public DefaultHttpClientFactory(CoreComponents coreComponents, SslContextsFactory sslContextsFactory) {
        this.coreComponents = coreComponents;
        this.sslContextsFactory = sslContextsFactory;
        EventLoopGroups.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        this.httpConfig = coreComponents.configuration().http();
        SystemProps$.MODULE$.setSystemPropertyIfUndefined("io.netty.allocator.type", (Object)this.httpConfig().advanced().allocator());
        SystemProps$.MODULE$.setSystemPropertyIfUndefined("io.netty.maxThreadLocalCharBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.httpConfig().advanced().maxThreadLocalCharBufferSize()));
    }
}

