/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Bytes$;
import io.gatling.commons.util.CompositeByteArrayInputStream;
import io.gatling.commons.util.FastByteArrayInputStream;
import io.gatling.http.response.InputStreamResponseBody$;
import io.gatling.http.response.ResponseBody;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.nio.charset.Charset;
import scala.Array$;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001]<Q\u0001D\u0007\t\u0002Y1Q\u0001G\u0007\t\u0002eAQ\u0001I\u0001\u0005\u0002\u0005BQAI\u0001\u0005\u0002\r2A\u0001G\u0007\u0001K!A1\u0007\u0002B\u0001B\u0003%A\u0007\u0003\u0005G\t\t\u0005\t\u0015!\u0003H\u0011\u0015\u0001C\u0001\"\u0001Q\u0011!\u0019F\u0001#b\u0001\n\u0003\"\u0006\u0002C/\u0005\u0011\u000b\u0007I\u0011\t0\t\u0011\r$\u0001R1A\u0005B\u0011DQ!\u001a\u0003\u0005B\u0019\fq#\u00138qkR\u001cFO]3b[J+7\u000f]8og\u0016\u0014u\u000eZ=\u000b\u00059y\u0011\u0001\u0003:fgB|gn]3\u000b\u0005A\t\u0012\u0001\u00025uiBT!AE\n\u0002\u000f\u001d\fG\u000f\\5oO*\tA#\u0001\u0002j_\u000e\u0001\u0001CA\f\u0002\u001b\u0005i!aF%oaV$8\u000b\u001e:fC6\u0014Vm\u001d9p]N,'i\u001c3z'\t\t!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\tQ!\u00199qYf$2\u0001\n7w!\t9Ba\u0005\u0003\u00055\u0019J\u0003CA\f(\u0013\tASB\u0001\u0007SKN\u0004xN\\:f\u0005>$\u0017\u0010\u0005\u0002+c5\t1F\u0003\u0002-[\u0005a1oY1mC2|wmZ5oO*\u0011afL\u0001\tif\u0004Xm]1gK*\t\u0001'A\u0002d_6L!AM\u0016\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007G\",hn[:\u0011\u0007Uj\u0004I\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011(F\u0001\u0007yI|w\u000e\u001e \n\u0003uI!\u0001\u0010\u000f\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\u0004'\u0016\f(B\u0001\u001f\u001d!\rY\u0012iQ\u0005\u0003\u0005r\u0011Q!\u0011:sCf\u0004\"a\u0007#\n\u0005\u0015c\"\u0001\u0002\"zi\u0016\fqa\u00195beN,G\u000f\u0005\u0002I\u001d6\t\u0011J\u0003\u0002G\u0015*\u00111\nT\u0001\u0004]&|'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f&\u0013qa\u00115beN,G\u000fF\u0002%#JCQaM\u0004A\u0002QBQAR\u0004A\u0002\u001d\u000baa\u001d;sS:<W#A+\u0011\u0005YSfBA,Y!\t9D$\u0003\u0002Z9\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tIF$A\u0003dQ\u0006\u00148/F\u0001`!\rY\u0012\t\u0019\t\u00037\u0005L!A\u0019\u000f\u0003\t\rC\u0017M]\u0001\u0006Ef$Xm]\u000b\u0002\u0001\u000611\u000f\u001e:fC6,\u0012a\u001a\t\u0003Q*l\u0011!\u001b\u0006\u0003)1K!a[5\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006g\r\u0001\r!\u001c\t\u0004kur\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u0019\u0011WO\u001a4fe*\u00111oE\u0001\u0006]\u0016$H/_\u0005\u0003kB\u0014qAQ=uK\n+h\rC\u0003G\u0007\u0001\u0007q\t")
public class InputStreamResponseBody
implements ResponseBody,
LazyLogging {
    private String string;
    private char[] chars;
    private byte[] bytes;
    private final Seq<byte[]> chunks;
    private final Charset charset;
    private transient Logger logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static InputStreamResponseBody apply(Seq<ByteBuf> seq, Charset charset) {
        return InputStreamResponseBody$.MODULE$.apply(seq, charset);
    }

    private Logger logger$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String string$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.string = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.string;
    }

    @Override
    public String string() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.string$lzycompute() : this.string;
    }

    private char[] chars$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.chars = this.string().toCharArray();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.chars;
    }

    @Override
    public char[] chars() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.chars$lzycompute() : this.chars;
    }

    private byte[] bytes$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bytes = Bytes$.MODULE$.byteArraysToByteArray(this.chunks);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bytes;
    }

    @Override
    public byte[] bytes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.bytes$lzycompute() : this.bytes;
    }

    @Override
    public InputStream stream() {
        FastByteArrayInputStream fastByteArrayInputStream;
        int n = this.chunks.size();
        switch (n) {
            case 0: {
                fastByteArrayInputStream = new FastByteArrayInputStream(Array$.MODULE$.emptyByteArray());
                break;
            }
            case 1: {
                fastByteArrayInputStream = new FastByteArrayInputStream((byte[])this.chunks.head());
                break;
            }
            default: {
                fastByteArrayInputStream = new CompositeByteArrayInputStream(this.chunks);
                break;
            }
        }
        return fastByteArrayInputStream;
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = Bytes$.MODULE$.byteArraysToString(this.chunks, this.charset);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(33).append("Response body is not valid ").append(this.charset.name()).append(" bytes").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            String string2 = "";
            string = string2;
        }
        return string;
    }

    public InputStreamResponseBody(Seq<byte[]> chunks, Charset charset) {
        this.chunks = chunks;
        this.charset = charset;
        LazyLogging.$init$((LazyLogging)this);
    }
}

