/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.http.action.sse.SseInvalidContentTypeException;
import io.gatling.http.action.sse.SseInvalidStatusException;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.action.sse.fsm.SseStreamDecoder;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001B\t\u0013\u0005uA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u00199\u0005\u0001)A\u0005\t\"I\u0001\n\u0001a\u0001\u0002\u0004%I!\u0013\u0005\n#\u0002\u0001\r\u00111A\u0005\nIC\u0011b\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002&\t\u000fq\u0003\u0001\u0019!C\u0005;\"9\u0011\r\u0001a\u0001\n\u0013\u0011\u0007B\u00023\u0001A\u0003&a\fC\u0003f\u0001\u0011\u0005c\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003k\u0001\u0011\u00053\u000eC\u0003r\u0001\u0011\u0005#\u000fC\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\tY1k]3MSN$XM\\3s\u0015\t\u0019B#A\u0002tg\u0016T!!\u0006\f\u0002\r\u0005\u001cG/[8o\u0015\t9\u0002$\u0001\u0003iiR\u0004(BA\r\u001b\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aG\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001=\u0019b\u0003CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%2\u0012AB2mS\u0016tG/\u0003\u0002,Q\ta\u0001\n\u001e;q\u0019&\u001cH/\u001a8feB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003cI\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002g\u0005\u00191m\\7\n\u0005Ur#!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0004tiJ,\u0017-\u001c\t\u0003qmj\u0011!\u000f\u0006\u0003uI\t1AZ:n\u0013\ta\u0014HA\u0005Tg\u0016\u001cFO]3b[\u00061A(\u001b8jiz\"\"aP!\u0011\u0005\u0001\u0003Q\"\u0001\n\t\u000bY\u0012\u0001\u0019A\u001c\u0002\u000f\u0011,7m\u001c3feV\tA\t\u0005\u00029\u000b&\u0011a)\u000f\u0002\u0011'N,7\u000b\u001e:fC6$UmY8eKJ\f\u0001\u0002Z3d_\u0012,'\u000fI\u0001\bG\"\fgN\\3m+\u0005Q\u0005CA&P\u001b\u0005a%B\u0001%N\u0015\tq%$A\u0003oKR$\u00180\u0003\u0002Q\u0019\n91\t[1o]\u0016d\u0017aC2iC:tW\r\\0%KF$\"aU-\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\tUs\u0017\u000e\u001e\u0005\b5\u001a\t\t\u00111\u0001K\u0003\rAH%M\u0001\tG\"\fgN\\3mA\u000511\r\\8tK\u0012,\u0012A\u0018\t\u0003)~K!\u0001Y+\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0005M\u001b\u0007b\u0002.\n\u0003\u0003\u0005\rAX\u0001\bG2|7/\u001a3!\u0003\u001dygn\u0016:ji\u0016$\"aU4\t\u000b![\u0001\u0019\u0001&\u0002\u0019\rdwn]3DQ\u0006tg.\u001a7\u0015\u0003M\u000bAc\u001c8GS:\fGn\u00117jK:$(+Z9vKN$HCA*m\u0011\u0015iW\u00021\u0001o\u0003\u001d\u0011X-];fgR\u0004\"aJ8\n\u0005AD#a\u0002*fcV,7\u000f^\u0001\u000f_:DE\u000f\u001e9SKN\u0004xN\\:f)\r\u00196O \u0005\u0006i:\u0001\r!^\u0001\u0007gR\fG/^:\u0011\u0005YdX\"A<\u000b\u0005]A(BA={\u0003\u0015\u0019w\u000eZ3d\u0015\tYX*A\u0004iC:$G.\u001a:\n\u0005u<(A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukNDaa \bA\u0002\u0005\u0005\u0011a\u00025fC\u0012,'o\u001d\t\u0004m\u0006\r\u0011bAA\u0003o\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0003]yg\u000e\u0013;uaJ+7\u000f]8og\u0016\u0014u\u000eZ=DQVt7\u000eF\u0003T\u0003\u0017\tY\u0002C\u0004\u0002\u000e=\u0001\r!a\u0004\u0002\u000b\rDWO\\6\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006N\u0003\u0019\u0011WO\u001a4fe&!\u0011\u0011DA\n\u0005\u001d\u0011\u0015\u0010^3Ck\u001aDa!!\b\u0010\u0001\u0004q\u0016\u0001\u00027bgR\f1b\u001c8UQJ|w/\u00192mKR\u00191+a\t\t\u000f\u0005\u0015\u0002\u00031\u0001\u0002(\u0005IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0003S\tID\u0004\u0003\u0002,\u0005Ub\u0002BA\u0017\u0003gi!!a\f\u000b\u0007\u0005EB$\u0001\u0004=e>|GOP\u0005\u0002-&\u0019\u0011qG+\u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005%!\u0006N]8xC\ndWMC\u0002\u00028U\u0003")
public final class SseListener
implements HttpListener,
StrictLogging {
    private final SseStream stream;
    private final SseStreamDecoder decoder;
    private Channel channel;
    private boolean closed;
    private Logger logger;

    public void onSend() {
        super.onSend();
    }

    public void onProtocolAwareness(boolean x$1) {
        super.onProtocolAwareness(x$1);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SseStreamDecoder decoder() {
        return this.decoder;
    }

    private Channel channel() {
        return this.channel;
    }

    private void channel_$eq(Channel x$1) {
        this.channel = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void onWrite(Channel channel) {
        this.channel_$eq(channel);
    }

    public void closeChannel() {
        if (this.channel() != null) {
            this.closed_$eq(true);
            this.channel().close();
            boolean bl = this.channel() == null;
            return;
        }
    }

    public void onFinalClientRequest(Request request) {
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        if (!this.closed()) {
            BoxedUnit boxedUnit;
            String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status {} Content-Type {} received for SSE", new Object[]{BoxesRunTime.boxToInteger((int)status.code()), contentType});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HttpResponseStatus httpResponseStatus = status;
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
            HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
            if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
                if (contentType != null && contentType.startsWith(HttpHeaderValues.TEXT_EVENT_STREAM.toString())) {
                    this.stream.connected();
                    return;
                }
                this.onThrowable(new SseInvalidContentTypeException(contentType));
                return;
            }
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NO_CONTENT;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                this.stream.endOfStream();
                this.closeChannel();
                return;
            }
            this.onThrowable(new SseInvalidStatusException(status.code()));
            return;
        }
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        if (!this.closed()) {
            Seq<ServerSentEvent> events = this.decoder().decodeStream(chunk);
            events.foreach((Function1 & Serializable)event -> {
                this.stream.eventReceived(event);
                return BoxedUnit.UNIT;
            });
            if (last) {
                this.stream.closedByServer();
                return;
            }
            return;
        }
    }

    public void onThrowable(Throwable throwable) {
        if (!this.closed()) {
            this.closeChannel();
            this.stream.crash(throwable);
            return;
        }
    }

    public SseListener(SseStream stream) {
        this.stream = stream;
        StrictLogging.$init$((StrictLogging)this);
        this.decoder = new SseStreamDecoder();
        this.closed = false;
        Statics.releaseFence();
    }
}

