/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.builder.BodyAttributes;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpParam;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.package$;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\tMu!\u0002\u0012$\u0011\u0003qc!\u0002\u0019$\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%Ia\u000f\u0005\u0007?\u0006\u0001\u000b\u0011\u0002\u001f\t\u000b\u001d\fA\u0011\u00025\u0007\u000bA\u001a#!a\u0007\t\u0015\u0005\rbA!A!\u0002\u0013\t)\u0003\u0003\u0006\u0002,\u0019\u0011\t\u0011)A\u0005\u0003[A!\"a\r\u0007\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011)\tYD\u0002B\u0001B\u0003%\u0011Q\b\u0005\u000b\u0003\u00132!\u0011!Q\u0001\n\u0005-\u0003BCA,\r\t\u0005\t\u0015!\u0003\u0002Z!1\u0001H\u0002C\u0001\u0003KBq!!\u001e\u0007\t#\n9\bC\u0004\u00026\u001a!I!a.\t\u000f\u0005%h\u0001\"\u0003\u0002l\"9!1\u0001\u0004\u0005\n\t\u0015\u0001\"\u0003B\u000b\r\t\u0007I\u0011\u0002B\f\u0011!\u0011)C\u0002Q\u0001\n\te\u0001\"\u0003B\u0014\r\t\u0007I\u0011\u0002B\u0015\u0011!\u0011\tD\u0002Q\u0001\n\t-\u0002\"\u0003B\u001a\r\t\u0007I\u0011\u0002B\u0015\u0011!\u0011)D\u0002Q\u0001\n\t-\u0002b\u0002B\u001c\r\u0011%!\u0011\b\u0005\n\u0005\u00132!\u0019!C\u0005\u0005SA\u0001Ba\u0013\u0007A\u0003%!1\u0006\u0005\b\u0005\u001b2A\u0011\u0002B(\u0011%\u0011YF\u0002b\u0001\n\u0013\u0011i\u0006\u0003\u0005\u0003f\u0019\u0001\u000b\u0011\u0002B0\u0011\u001d\u00119G\u0002C)\u0005SBqA!\u001c\u0007\t#\u0012y\u0007C\u0004\u0003\u0000\u0019!IA!!\t\u000f\t5e\u0001\"\u0011\u0003\u0010\u0006a\u0002\n\u001e;q%\u0016\fX/Z:u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014(B\u0001\u0013&\u0003\u001d\u0011W/\u001b7eKJT!AJ\u0014\u0002\u000fI,\u0017/^3ti*\u0011\u0001&K\u0001\u0005QR$\bO\u0003\u0002+W\u00059q-\u0019;mS:<'\"\u0001\u0017\u0002\u0005%|7\u0001\u0001\t\u0003_\u0005i\u0011a\t\u0002\u001d\u0011R$\bOU3rk\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s'\t\t!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\n\u0011DY8esB\u000b'\u000f^:U_6+H\u000e^5qCJ$8OW3s_V\tA\bE\u0002>\u0005\u0012k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b!B^1mS\u0012\fG/[8o\u0015\t\t\u0015&A\u0004d_6lwN\\:\n\u0005\rs$A\u0003,bY&$\u0017\r^5p]B\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%.\u0003\u0019a$o\\8u}%\tQ'\u0003\u0002Mi\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\u0011a\u0015n\u001d;\u000b\u00051#\u0004GA)^!\r\u0011\u0016lW\u0007\u0002'*\u0011A+V\u0001\n[VdG/\u001b9beRT!AV,\u0002\t\t|G-\u001f\u0006\u00031\u001e\naa\u00197jK:$\u0018B\u0001.T\u0005\u0011\u0001\u0016M\u001d;\u0011\u0005qkF\u0002\u0001\u0003\n=\u0012\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00132\u0003i\u0011w\u000eZ=QCJ$8\u000fV8Nk2$\u0018\u000e]1siNTVM]8!#\t\tG\r\u0005\u00024E&\u00111\r\u000e\u0002\b\u001d>$\b.\u001b8h!\t\u0019T-\u0003\u0002gi\t\u0019\u0011I\\=\u0002+\t|G-\u001f)beR\u001cHk\\'vYRL\u0007/\u0019:ugR\u0019\u0011\u000e]<\u0011\u0007u\u0012%\u000eE\u0002F\u001b.\u0004$\u0001\u001c8\u0011\u0007IKV\u000e\u0005\u0002]]\u0012Iq.BA\u0001\u0002\u0003\u0015\t\u0001\u0019\u0002\u0004?\u0012\u0012\u0004\"B9\u0006\u0001\u0004\u0011\u0018!\u00032pIf\u0004\u0016M\u001d;t!\r)Uj\u001d\t\u0003iVl\u0011!J\u0005\u0003m\u0016\u0012\u0001BQ8esB\u000b'\u000f\u001e\u0005\u0006q\u0016\u0001\r!_\u0001\bg\u0016\u001c8/[8o!\tQh0D\u0001|\u0015\tAHP\u0003\u0002~S\u0005!1m\u001c:f\u0013\ty8PA\u0004TKN\u001c\u0018n\u001c8)\u000f\u0015\t\u0019!a\u0005\u0002\u0016A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00027b]\u001eT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\tTkB\u0004(/Z:t/\u0006\u0014h.\u001b8hg\u0006)a/\u00197vK2\u0012\u0011qC\u0011\u0003\u00033\t\u0001e\u001c:h]]\f'\u000f\u001e:f[>4XM\u001d\u0018xCJ$8O\f'jgR\f\u0005\u000f]3oIN\u0019a!!\b\u0011\u0007=\ny\"C\u0002\u0002\"\r\u0012\u0001DU3rk\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s\u0003A\u0019w.\\7p]\u0006#HO]5ckR,7\u000fE\u00020\u0003OI1!!\u000b$\u0005A\u0019u.\\7p]\u0006#HO]5ckR,7/\u0001\bc_\u0012L\u0018\t\u001e;sS\n,H/Z:\u0011\u0007=\ny#C\u0002\u00022\r\u0012aBQ8es\u0006#HO]5ckR,7/\u0001\biiR\u0004\u0018\t\u001e;sS\n,H/Z:\u0011\u0007=\n9$C\u0002\u0002:\r\u0012a\u0002\u0013;ua\u0006#HO]5ckR,7/\u0001\u0006iiR\u00048)Y2iKN\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007:\u0013!B2bG\",\u0017\u0002BA$\u0003\u0003\u0012!\u0002\u0013;ua\u000e\u000b7\r[3t\u00031AG\u000f\u001e9Qe>$xnY8m!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)O\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002V\u0005=#\u0001\u0004%uiB\u0004&o\u001c;pG>d\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\ty\u0006`\u0001\u0007G>tg-[4\n\t\u0005\r\u0014Q\f\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u001d\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0002tA\u0011qF\u0002\u0005\b\u0003Gi\u0001\u0019AA\u0013\u0011\u001d\tY#\u0004a\u0001\u0003[Aq!a\r\u000e\u0001\u0004\t)\u0004C\u0004\u0002<5\u0001\r!!\u0010\t\u000f\u0005%S\u00021\u0001\u0002L!9\u0011qK\u0007A\u0002\u0005e\u0013\u0001E2p]\u001aLw-\u001e:f\u0011\u0016\fG-\u001a:t)\u0011\tI(!-\u0011\u0011\u0005m\u00141QAE\u0003\u001fsA!! \u0002\u0000A\u0011q\tN\u0005\u0004\u0003\u0003#\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%aA'ba*\u0019\u0011\u0011\u0011\u001b\u0011\t\u0005\u0015\u00111R\u0005\u0005\u0003\u001b\u000b9A\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\r\u0005\u0004\u0002\u0012\u0006\u0015\u00161\u0016\b\u0005\u0003'\u000b\u0019K\u0004\u0003\u0002\u0016\u0006\u0005f\u0002BAL\u0003?sA!!'\u0002\u001e:\u0019q)a'\n\u00031J!AK\u0016\n\u0005uL\u0013B\u0001=}\u0013\ta50\u0003\u0003\u0002(\u0006%&AC#yaJ,7o]5p]*\u0011Aj\u001f\t\u0005\u0003w\ni+\u0003\u0003\u00020\u0006\u001d%AB*ue&tw\rC\u0004\u00024:\u0001\r!!\u001f\u0002\u0015I\fw\u000fS3bI\u0016\u00148/\u0001\u0013nKJ<WMR8s[B\u000b'/Y7t\u0003:$gi\u001c:n\u0013:$x\u000eU1sC6TE*[:u)!\tI,!4\u0002Z\u0006\u001d\b\u0003B\u001fC\u0003w\u0003b!!0\u0002D\u0006\u0015WBAA`\u0015\u0011\t\t-a\u0003\u0002\tU$\u0018\u000e\\\u0005\u0004\u001d\u0006}\u0006\u0003BAd\u0003\u0013l\u0011aV\u0005\u0004\u0003\u0017<&!\u0002)be\u0006l\u0007bBAh\u001f\u0001\u0007\u0011\u0011[\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0015k\u00151\u001b\t\u0004_\u0005U\u0017bAAlG\tI\u0001\n\u001e;q!\u0006\u0014\u0018-\u001c\u0005\b\u00037|\u0001\u0019AAo\u0003%i\u0017-\u001f2f\r>\u0014X\u000eE\u00034\u0003?\f\u0019/C\u0002\u0002bR\u0012aa\u00149uS>t\u0007CBAI\u0003K\u000b)\u000fE\u0004\u0002|\u0005\r\u00151\u00163\t\u000ba|\u0001\u0019A=\u00025\r|gNZ5hkJ,W*\u001e7uSB\f'\u000f\u001e$pe6$\u0015\r^1\u0015\r\u00055\u0018q_A}a\u0011\ty/a=\u0011\tu\u0012\u0015\u0011\u001f\t\u00049\u0006MHACA{!\u0005\u0005\t\u0011!B\u0001A\n\u0019q\fJ\u001a\t\u000ba\u0004\u0002\u0019A=\t\u000f\u0005m\b\u00031\u0001\u0002~\u0006q!/Z9vKN$()^5mI\u0016\u0014\b\u0003BAd\u0003\u007fL1A!\u0001X\u00059\u0011V-];fgR\u0014U/\u001b7eKJ\fqcY8oM&<WO]3G_JlWK\u001d7F]\u000e|G-\u001a3\u0015\r\t\u001d!\u0011\u0003B\na\u0011\u0011IA!\u0004\u0011\tu\u0012%1\u0002\t\u00049\n5AA\u0003B\b#\u0005\u0005\t\u0011!B\u0001A\n\u0019q\f\n\u001b\t\u000ba\f\u0002\u0019A=\t\u000f\u0005m\u0018\u00031\u0001\u0002~\u0006\tS.Y=cKJ+\u0017/^3ti\n{G-\u001f\"vS2$WM]#yaJ,7o]5p]V\u0011!\u0011\u0004\t\u0006g\u0005}'1\u0004\t\u0007\u0003#\u000b)K!\b\u0011\t\t}!\u0011E\u0007\u0002+&\u0019!1E+\u0003%I+\u0017/^3ti\n{G-\u001f\"vS2$WM]\u0001#[\u0006L(-\u001a*fcV,7\u000f\u001e\"pIf\u0014U/\u001b7eKJ,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002\u0011!\f7\u000fU1siN,\"Aa\u000b\u0011\u0007M\u0012i#C\u0002\u00030Q\u0012qAQ8pY\u0016\fg.A\u0005iCN\u0004\u0016M\u001d;tA\u00059\u0001.Y:G_Jl\u0017\u0001\u00035bg\u001a{'/\u001c\u0011\u0002\u001b\r|gNZ5hkJ,'i\u001c3z)\u0019\u0011YD!\u0012\u0003HA\"!Q\bB!!\u0011i$Ia\u0010\u0011\u0007q\u0013\t\u0005\u0002\u0006\u0003Da\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00136\u0011\u0015A\b\u00041\u0001z\u0011\u001d\tY\u0010\u0007a\u0001\u0003{\f1\"\u001a8bE2,\u0007\n\u001e;qe\u0005aQM\\1cY\u0016DE\u000f\u001e93A\u000592m\u001c8gS\u001e,(/\u001a)sS>\u00148J\\8xY\u0016$w-\u001a\u000b\u0007\u0005#\u00129F!\u0017\u0011\u0007M\u0012\u0019&C\u0002\u0003VQ\u0012A!\u00168ji\")\u0001p\u0007a\u0001s\"9\u00111`\u000eA\u0002\u0005u\u0018A\u0004:fcV,7\u000f\u001e+j[\u0016|W\u000f^\u000b\u0003\u0005?\u00022a\rB1\u0013\r\u0011\u0019\u0007\u000e\u0002\u0005\u0019>tw-A\bsKF,Xm\u001d;US6,w.\u001e;!\u0003]\u0019wN\u001c4jOV\u0014XMU3rk\u0016\u001cH\u000fV5nK>,H\u000f\u0006\u0003\u0003R\t-\u0004bBA~=\u0001\u0007\u0011Q`\u0001\u001aG>tg-[4ve\u0016\u0004&o\u001c;pG>d7\u000b]3dS\u001aL7\r\u0006\u0004\u0003r\tm$Q\u0010\u0019\u0005\u0005g\u00129\b\u0005\u0003>\u0005\nU\u0004c\u0001/\u0003x\u0011Q!\u0011P\u0010\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#c\u0007C\u0003y?\u0001\u0007\u0011\u0010C\u0004\u0002|~\u0001\r!!@\u0002/\r|gNZ5hkJ,7)Y2iS:<\u0007*Z1eKJ\u001cHC\u0002B)\u0005\u0007\u0013)\tC\u0003yA\u0001\u0007\u0011\u0010\u0003\u0004'A\u0001\u0007!q\u0011\t\u0005\u0003\u000f\u0014I)C\u0002\u0003\f^\u0013qAU3rk\u0016\u001cH/A\u0003ck&dG-\u0006\u0002\u0003\u0012B1\u0011\u0011SAS\u0005\u000f\u0003")
public final class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final BodyAttributes bodyAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression;
    private final boolean hasParts;
    private final boolean hasForm;
    private final boolean enableHttp2;
    private final long requestTimeout;

    @Override
    public Map<CharSequence, Function1<Session, Validation<String>>> configureHeaders(Map<CharSequence, Function1<Session, Validation<String>>> rawHeaders) {
        Option<BodyAttributes.HeadersBuiltIn> option = this.bodyAttributes.headersBuiltIn();
        if (option instanceof Some) {
            Some some = (Some)option;
            BodyAttributes.HeadersBuiltIn headersBuiltIn = (BodyAttributes.HeadersBuiltIn)some.value();
            return headersBuiltIn.patch(rawHeaders, this.bodyAttributes.body().nonEmpty() || this.bodyAttributes.bodyParts().nonEmpty());
        }
        return rawHeaders;
    }

    private Validation<java.util.List<Param>> mergeFormParamsAndFormIntoParamJList(List<HttpParam> params, Option<Function1<Session, Validation<Map<String, Object>>>> maybeForm, Session session) {
        Validation<java.util.List<Param>> formParams = package$.MODULE$.resolveParamJList(params, session);
        Option<Function1<Session, Validation<Map<String, Object>>>> option = maybeForm;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 form = (Function1)some.value();
            return formParams.flatMap((Function1 & Serializable)resolvedFormParams -> ((Validation)form.apply((Object)session)).map((Function1 & Serializable)resolvedForm -> {
                Map formParamsByName = CollectionConverters$.MODULE$.ListHasAsScala(resolvedFormParams).asScala().groupBy((Function1 & Serializable)x$1 -> x$1.getName());
                Map formFieldsByName = (Map)resolvedForm.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        Object value2 = tuple2._2();
                        Object object = value2;
                        if (object instanceof scala.collection.immutable.Seq) {
                            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)object;
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), seq.map((Function1 & Serializable)value -> new Param(key, value.toString())));
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new .colon.colon((Object)new Param(key, object.toString()), (List)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)tuple2);
                });
                java.util.List javaParams = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((MapOps)formFieldsByName.$plus$plus((IterableOnce)formParamsByName)).values().flatten(Predef$.MODULE$.$conforms())).toSeq()).asJava();
                return javaParams;
            }));
        }
        return formParams;
    }

    private Validation<?> configureMultipartFormData(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.bodyAttributes.formParams(), this.bodyAttributes.form(), session).flatMap((Function1 & Serializable)params -> {
            Buffer stringParts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().map((Function1 & Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null));
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts($this.bodyAttributes.bodyParts(), session).map((Function1 & Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)stringParts.$plus$plus((IterableOnce)parts)).asJava())));
        });
    }

    private Validation<?> configureFormUrlEncoded(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.bodyAttributes.formParams(), this.bodyAttributes.form(), session).map((Function1 & Serializable)params -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(params)));
    }

    private Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression() {
        return this.maybeRequestBodyBuilderExpression;
    }

    private boolean hasParts() {
        return this.hasParts;
    }

    private boolean hasForm() {
        return this.hasForm;
    }

    private Validation<?> configureBody(Session session, RequestBuilder requestBuilder) {
        Option<Function1<Session, Validation<RequestBodyBuilder>>> option = this.maybeRequestBodyBuilderExpression();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 requestBodyBuilderExpression = (Function1)some.value();
            return ((Validation)requestBodyBuilderExpression.apply((Object)session)).map((Function1 & Serializable)x$1 -> requestBuilder.setBodyBuilder(x$1));
        }
        if (this.hasParts() || this.hasForm() && HttpHelper$.MODULE$.isMultipartFormData(requestBuilder.getContentType())) {
            return this.configureMultipartFormData(session, requestBuilder);
        }
        if (this.hasForm()) {
            return this.configureFormUrlEncoded(session, requestBuilder);
        }
        return Validation$.MODULE$.unit();
    }

    private boolean enableHttp2() {
        return this.enableHttp2;
    }

    private void configurePriorKnowledge(Session session, RequestBuilder requestBuilder) {
        if (this.enableHttp2()) {
            Option<Http2PriorKnowledge> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.getHttp2PriorKnowledge(session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            requestBuilder.setHttp2Enabled(true).setHttp2PriorKnowledge((Http2PriorKnowledge)http2PriorKnowledge.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    private long requestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(this.requestTimeout());
    }

    @Override
    public Validation<?> configureProtocolSpecific(Session session, RequestBuilder requestBuilder) {
        return this.configureBody(session, requestBuilder).map((Function1 & Serializable)x$11 -> {
            Object object = x$11;
            this.configurePriorKnowledge(session, requestBuilder);
            return BoxedUnit.UNIT;
        });
    }

    private void configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Function1<Session, Validation<Request>> build() {
        Function1<Session, Validation<Request>> exp = super.build();
        if (this.httpProtocol.requestPart().cache()) {
            return (Function1 & Serializable)session -> ((Validation)exp.apply(session)).map((Function1 & Serializable)request -> {
                this.configureCachingHeaders((Session)session, (Request)request);
                return request;
            });
        }
        return exp;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry != null) {
            Option<String> etag = contentCacheEntry.etag();
            Option<String> lastModified = contentCacheEntry.lastModified();
            etag.foreach((Function1 & Serializable)x$12 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$12));
            lastModified.foreach((Function1 & Serializable)x$13 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$13));
            return;
        }
        throw new MatchError((Object)contentCacheEntry);
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, BodyAttributes bodyAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        this.bodyAttributes = bodyAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(bodyAttributes.body().isEmpty() || bodyAttributes.bodyParts().isEmpty(), (Function0 & Serializable)() -> "Can't have both a body and body parts!");
        this.maybeRequestBodyBuilderExpression = bodyAttributes.body().map((Function1 & Serializable)x0$1 -> {
            Body body = x0$1;
            if (body instanceof StringBody) {
                StringBody stringBody = (StringBody)body;
                Function1 string = stringBody.string();
                return (Function1 & Serializable)x$3 -> ((Validation)string.apply(x$3)).map((Function1 & Serializable)x$4 -> new StringRequestBodyBuilder(x$4));
            }
            if (body instanceof RawFileBody) {
                RawFileBody rawFileBody = (RawFileBody)body;
                Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
                return (Function1 & Serializable)x$5 -> ((Validation)resourceWithCachedBytes.apply(x$5)).map((Function1 & Serializable)x0$2 -> {
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$2;
                    if (resourceAndCachedBytes != null) {
                        Resource resource = resourceAndCachedBytes.resource();
                        Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                        Option option = cachedBytes;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            byte[] bytes = (byte[])some.value();
                            return new ByteArrayRequestBodyBuilder(bytes, resource.name());
                        }
                        return new FileRequestBodyBuilder(resource.file());
                    }
                    throw new MatchError((Object)resourceAndCachedBytes);
                });
            }
            if (body instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body;
                Function1 bytes = byteArrayBody.bytes();
                return (Function1 & Serializable)x$6 -> ((Validation)bytes.apply(x$6)).map((Function1 & Serializable)x$7 -> new ByteArrayRequestBodyBuilder(x$7, null));
            }
            if (body instanceof ElBody) {
                ElBody elBody = (ElBody)body;
                return (Function1 & Serializable)x$8 -> ((Validation)elBody.asStringWithCachedBytes().apply(x$8)).map((Function1 & Serializable)chunks -> new StringChunksRequestBodyBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)chunks).asJava()));
            }
            if (body instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body;
                Function1 is = inputStreamBody.is();
                return (Function1 & Serializable)x$9 -> ((Validation)is.apply(x$9)).map((Function1 & Serializable)x$10 -> new InputStreamRequestBodyBuilder(x$10));
            }
            throw new MatchError((Object)body);
        });
        this.hasParts = bodyAttributes.bodyParts().nonEmpty();
        this.hasForm = bodyAttributes.formParams().nonEmpty() || bodyAttributes.form().nonEmpty();
        this.enableHttp2 = httpProtocol.enginePart().enableHttp2();
        this.requestTimeout = ((FiniteDuration)httpAttributes.requestTimeout().getOrElse((Function0 & Serializable)() -> $this.configuration.http().requestTimeout())).toMillis();
    }
}

