/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.check.body;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.json.JsonParsers;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.check.HttpCheckMaterializer;
import io.gatling.http.check.HttpCheckScope$Body$;
import io.gatling.http.response.Response;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.matching.Regex;

public final class HttpBodyJsonpCheckMaterializer$ {
    public static final HttpBodyJsonpCheckMaterializer$ MODULE$ = new HttpBodyJsonpCheckMaterializer$();
    private static final Regex JsonpRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\w+(?:\\[\\\"\\w+\\\"\\]|\\.\\w+)*\\((.*)\\);?\\s*$"));
    private static final Failure JsonpRegexFailure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Regex could not extract JSON object from JSONP response"));

    private Regex JsonpRegex() {
        return JsonpRegex;
    }

    private Failure JsonpRegexFailure() {
        return JsonpRegexFailure;
    }

    public <T> CheckMaterializer<T, HttpCheck, Response, JsonNode> instance(JsonParsers jsonParsers) {
        Function1 & Serializable preparer = (Function1 & Serializable)response -> {
            Option option;
            String string = response.body().string();
            if (string != null && !(option = MODULE$.JsonpRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String jsonp = (String)((LinearSeqOps)option.get()).apply(0);
                return jsonParsers.safeParse(jsonp);
            }
            return MODULE$.JsonpRegexFailure();
        };
        return new HttpCheckMaterializer(HttpCheckScope$Body$.MODULE$, preparer);
    }

    private HttpBodyJsonpCheckMaterializer$() {
    }
}

