/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request;

import io.gatling.commons.validation.Validation;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.ElFileBodies;
import io.gatling.core.body.RawFileBodies;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.core.util.Resource;
import io.gatling.http.client.Param;
import io.gatling.http.client.body.multipart.ByteArrayPart;
import io.gatling.http.client.body.multipart.FilePart;
import io.gatling.http.client.body.multipart.Part;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.BodyPartAttributes;
import io.gatling.http.request.BodyPartAttributes$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.Function8;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;

public final class BodyPart$
implements scala.Serializable {
    public static BodyPart$ MODULE$;

    static {
        new BodyPart$();
    }

    public BodyPart rawFileBodyPart(Option<Function1<Session, Validation<String>>> name2, Function1<Session, Validation<String>> filePath, RawFileBodies rawFileBodies) {
        Function1 function1 = rawFileBodies.asResourceAndCachedBytes(filePath);
        return new BodyPart(name2, (Function8 & Serializable & scala.Serializable)(name, charset, transferEncoding, contentId, dispositionType, contentType, customHeaders, fileName) -> MODULE$.fileBodyPartBuilder((Function1<Session, Validation<ResourceAndCachedBytes>>)function1, (String)name, (Option<Charset>)charset, (Option<String>)transferEncoding, (Option<String>)contentId, (Option<String>)dispositionType, (Option<String>)contentType, (List<Param>)customHeaders, (Option<String>)fileName), BodyPartAttributes$.MODULE$.Empty());
    }

    public BodyPart elFileBodyPart(Option<Function1<Session, Validation<String>>> name, Function1<Session, Validation<String>> filePath, Charset defaultCharset, ElFileBodies elFileBodies) {
        return this.stringBodyPart(name, (Function1<Session, Validation<String>>)new ElBody(elFileBodies.parse(filePath)), defaultCharset);
    }

    public BodyPart stringBodyPart(Option<Function1<Session, Validation<String>>> name2, Function1<Session, Validation<String>> string, Charset defaultCharset) {
        return new BodyPart(name2, (Function8 & Serializable & scala.Serializable)(name, charset, transferEncoding, contentId, dispositionType, contentType, customHeaders, fileName) -> MODULE$.stringBodyPartBuilder(string, defaultCharset, (String)name, (Option<Charset>)charset, (Option<String>)transferEncoding, (Option<String>)contentId, (Option<String>)dispositionType, (Option<String>)contentType, (List<Param>)customHeaders, (Option<String>)fileName), BodyPartAttributes$.MODULE$.Empty());
    }

    public BodyPart byteArrayBodyPart(Option<Function1<Session, Validation<String>>> name2, Function1<Session, Validation<byte[]>> bytes) {
        return new BodyPart(name2, (Function8 & Serializable & scala.Serializable)(name, charset, transferEncoding, contentId, dispositionType, contentType, customHeaders, fileName) -> MODULE$.byteArrayBodyPartBuilder(bytes, (String)name, (Option<Charset>)charset, (Option<String>)transferEncoding, (Option<String>)contentId, (Option<String>)dispositionType, (Option<String>)contentType, (List<Param>)customHeaders, (Option<String>)fileName), BodyPartAttributes$.MODULE$.Empty());
    }

    private Function1<Session, Validation<Part<?>>> stringBodyPartBuilder(Function1<Session, Validation<String>> string, Charset defaultCharset, String name, Option<Charset> charset, Option<String> transferEncoding, Option<String> contentId, Option<String> dispositionType, Option<String> contentType, List<Param> customHeaders, Option<String> fileName) {
        Option<String> option = fileName;
        Function1<Session, Validation<Part<?>>> function1 = None$.MODULE$.equals(option) ? package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(string), (Function1 & Serializable & scala.Serializable)resolvedString -> new StringPart(name, resolvedString, (Charset)charset.getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultCharset), (String)transferEncoding.orNull(Predef$.MODULE$.$conforms()), (String)contentId.orNull(Predef$.MODULE$.$conforms()), (String)dispositionType.orNull(Predef$.MODULE$.$conforms()), (String)contentType.orNull(Predef$.MODULE$.$conforms()), customHeaders)) : this.byteArrayBodyPartBuilder((Function1<Session, Validation<byte[]>>)package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(string), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getBytes((Charset)charset.getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultCharset))), name, charset, transferEncoding, contentId, dispositionType, contentType, customHeaders, fileName);
        return function1;
    }

    private Function1<Session, Validation<Part<?>>> byteArrayBodyPartBuilder(Function1<Session, Validation<byte[]>> bytes, String name, Option<Charset> charset, Option<String> transferEncoding, Option<String> contentId, Option<String> dispositionType, Option<String> contentType, List<Param> customHeaders, Option<String> fileName) {
        return package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(bytes), (Function1 & Serializable & scala.Serializable)resolvedBytes -> new ByteArrayPart(name, resolvedBytes, (Charset)charset.orNull(Predef$.MODULE$.$conforms()), (String)transferEncoding.orNull(Predef$.MODULE$.$conforms()), (String)contentId.orNull(Predef$.MODULE$.$conforms()), (String)dispositionType.orNull(Predef$.MODULE$.$conforms()), (String)contentType.orNull(Predef$.MODULE$.$conforms()), customHeaders, (String)fileName.orNull(Predef$.MODULE$.$conforms())));
    }

    private Function1<Session, Validation<Part<?>>> fileBodyPartBuilder(Function1<Session, Validation<ResourceAndCachedBytes>> resource, String name, Option<Charset> charset, Option<String> transferEncoding, Option<String> contentId, Option<String> dispositionType, Option<String> contentType, List<Param> customHeaders, Option<String> fileName) {
        return (Function1 & Serializable & scala.Serializable)session -> ((Validation)resource.apply(session)).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            FilePart filePart;
            ResourceAndCachedBytes resourceAndCachedBytes = x$2;
            if (resourceAndCachedBytes != null) {
                Resource resource = resourceAndCachedBytes.resource();
                Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                Option option = cachedBytes;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] bytes = (byte[])some.value();
                    filePart = new ByteArrayPart(name, bytes, (Charset)charset.orNull(Predef$.MODULE$.$conforms()), (String)transferEncoding.orNull(Predef$.MODULE$.$conforms()), (String)contentId.orNull(Predef$.MODULE$.$conforms()), (String)dispositionType.orNull(Predef$.MODULE$.$conforms()), (String)contentType.orNull(Predef$.MODULE$.$conforms()), customHeaders, (String)fileName.getOrElse((Function0 & Serializable & scala.Serializable)() -> resource.name()));
                } else {
                    filePart = new FilePart(name, resource.file(), (Charset)charset.orNull(Predef$.MODULE$.$conforms()), (String)transferEncoding.orNull(Predef$.MODULE$.$conforms()), (String)contentType.orNull(Predef$.MODULE$.$conforms()), (String)dispositionType.orNull(Predef$.MODULE$.$conforms()), (String)contentId.orNull(Predef$.MODULE$.$conforms()), customHeaders, (String)fileName.getOrElse((Function0 & Serializable & scala.Serializable)() -> resource.name()));
                }
            } else {
                throw new MatchError((Object)resourceAndCachedBytes);
            }
            FilePart filePart2 = filePart;
            return filePart2;
        });
    }

    public BodyPart apply(Option<Function1<Session, Validation<String>>> name, Function8<String, Option<Charset>, Option<String>, Option<String>, Option<String>, Option<String>, List<Param>, Option<String>, Function1<Session, Validation<Part<?>>>> partBuilder, BodyPartAttributes attributes) {
        return new BodyPart(name, partBuilder, attributes);
    }

    public Option<Tuple3<Option<Function1<Session, Validation<String>>>, Function8<String, Option<Charset>, Option<String>, Option<String>, Option<String>, Option<String>, List<Param>, Option<String>, Function1<Session, Validation<Part<?>>>>, BodyPartAttributes>> unapply(BodyPart x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.name(), x$0.partBuilder(), (Object)x$0.attributes()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BodyPart$() {
        MODULE$ = this;
    }
}

