/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.PebbleBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.RequestExpressionBuilder$;
import io.gatling.http.request.builder.package$;
import io.gatling.http.request.builder.package$HttpParams$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dw!B\f\u0019\u0011\u0003\u0019c!B\u0013\u0019\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%I\u0001\r\u0005\u0007!\u0006\u0001\u000b\u0011B\u0019\t\u000ba\u000bA\u0011B-\u0007\t\u0015B\u0002a\u001f\u0005\n\u007f\u001a\u0011\t\u0011)A\u0005\u0003\u0003A!\"a\u0002\u0007\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011)\tyA\u0002B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u0003;1!\u0011!Q\u0001\n\u0005}\u0001BCA\u0016\r\t\u0005\t\u0015!\u0003\u0002.!1QF\u0002C\u0001\u0003sAq!a\u0012\u0007\t\u0013\tI\u0005C\u0004\u0002^\u0019!I!a\u0018\t\u0013\u0005EdA1A\u0005\n\u0005M\u0004\u0002CAB\r\u0001\u0006I!!\u001e\t\u0013\u0005\u0015eA1A\u0005\n\u0005M\u0004\u0002CAD\r\u0001\u0006I!!\u001e\t\u000f\u0005%e\u0001\"\u0015\u0002\f\"9\u0011Q\u0013\u0004\u0005R\u0005M\u0004bBAL\r\u0011%\u0011\u0011\u0014\u0005\b\u0003O3A\u0011IAU\u0003qAE\u000f\u001e9SKF,Xm\u001d;FqB\u0014Xm]:j_:\u0014U/\u001b7eKJT!!\u0007\u000e\u0002\u000f\t,\u0018\u000e\u001c3fe*\u00111\u0004H\u0001\be\u0016\fX/Z:u\u0015\tib$\u0001\u0003iiR\u0004(BA\u0010!\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!I\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002%\u00035\t\u0001D\u0001\u000fIiR\u0004(+Z9vKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0014\u0005\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002G\u0005I\"m\u001c3z!\u0006\u0014Ho\u001d+p\u001bVdG/\u001b9beR\u001c(,\u001a:p+\u0005\t\u0004c\u0001\u001a8s5\t1G\u0003\u00025k\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005Yr\u0012aB2p[6|gn]\u0005\u0003qM\u0012!BV1mS\u0012\fG/[8o!\rQt(Q\u0007\u0002w)\u0011A(P\u0001\nS6lW\u000f^1cY\u0016T!AP\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Aw\t!A*[:ua\t\u0011e\nE\u0002D\u00152k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0011\"\\;mi&\u0004\u0018M\u001d;\u000b\u0005\u001dC\u0015\u0001\u00022pIfT!!\u0013\u000f\u0002\r\rd\u0017.\u001a8u\u0013\tYEI\u0001\u0003QCJ$\bCA'O\u0019\u0001!\u0011b\u0014\u0003\u0002\u0002\u0003\u0005)\u0011A)\u0003\u0007}#\u0013'\u0001\u000ec_\u0012L\b+\u0019:ugR{W*\u001e7uSB\f'\u000f^:[KJ|\u0007%\u0005\u0002S+B\u0011\u0001fU\u0005\u0003)&\u0012qAT8uQ&tw\r\u0005\u0002)-&\u0011q+\u000b\u0002\u0004\u0003:L\u0018!\u00062pIf\u0004\u0016M\u001d;t)>lU\u000f\u001c;ja\u0006\u0014Ho\u001d\u000b\u00045.\u0014\bc\u0001\u001a87B\u0019A\f\u001a4\u000f\u0005u\u0013gB\u00010b\u001b\u0005y&B\u00011#\u0003\u0019a$o\\8u}%\t!&\u0003\u0002dS\u00059\u0001/Y2lC\u001e,\u0017B\u0001!f\u0015\t\u0019\u0017\u0006\r\u0002hSB\u00191I\u00135\u0011\u00055KG!\u00036\u0006\u0003\u0003\u0005\tQ!\u0001R\u0005\ryFE\r\u0005\u0006Y\u0016\u0001\r!\\\u0001\nE>$\u0017\u0010U1siN\u00042\u0001\u00183o!\ty\u0007/D\u0001\u001b\u0013\t\t(D\u0001\u0005C_\u0012L\b+\u0019:u\u0011\u0015\u0019X\u00011\u0001u\u0003\u001d\u0019Xm]:j_:\u0004\"!^=\u000e\u0003YT!a]<\u000b\u0005at\u0012\u0001B2pe\u0016L!A\u001f<\u0003\u000fM+7o]5p]N\u0011a\u0001 \t\u0003IuL!A \r\u00031I+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'/\u0001\td_6lwN\\!uiJL'-\u001e;fgB\u0019A%a\u0001\n\u0007\u0005\u0015\u0001D\u0001\tD_6lwN\\!uiJL'-\u001e;fg\u0006q\u0001\u000e\u001e;q\u0003R$(/\u001b2vi\u0016\u001c\bc\u0001\u0013\u0002\f%\u0019\u0011Q\u0002\r\u0003\u001d!#H\u000f]!uiJL'-\u001e;fg\u0006Q\u0001\u000e\u001e;q\u0007\u0006\u001c\u0007.Z:\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u001d\u0003\u0015\u0019\u0017m\u00195f\u0013\u0011\tY\"!\u0006\u0003\u0015!#H\u000f]\"bG\",7/\u0001\u0007iiR\u0004\bK]8u_\u000e|G\u000e\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)\u0003H\u0001\taJ|Go\\2pY&!\u0011\u0011FA\u0012\u00051AE\u000f\u001e9Qe>$xnY8m\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024]\faaY8oM&<\u0017\u0002BA\u001c\u0003c\u0011AcR1uY&twmQ8oM&<WO]1uS>tG\u0003DA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0003C\u0001\u0013\u0007\u0011\u0019yH\u00021\u0001\u0002\u0002!9\u0011q\u0001\u0007A\u0002\u0005%\u0001bBA\b\u0019\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003;a\u0001\u0019AA\u0010\u0011\u001d\tY\u0003\u0004a\u0001\u0003[\t!cY8oM&<WO]3C_\u0012L\b+\u0019:ugRA\u00111JA+\u0003/\nY\u0006\u0005\u00033o\u00055\u0003\u0003BA(\u0003#j\u0011\u0001S\u0005\u0004\u0003'B%A\u0004*fcV,7\u000f\u001e\"vS2$WM\u001d\u0005\u0006g6\u0001\r\u0001\u001e\u0005\b\u00033j\u0001\u0019AA'\u00039\u0011X-];fgR\u0014U/\u001b7eKJDQ\u0001\\\u0007A\u00025\fqa]3u\u0005>$\u0017\u0010\u0006\u0005\u0002L\u0005\u0005\u00141MA3\u0011\u0015\u0019h\u00021\u0001u\u0011\u001d\tIF\u0004a\u0001\u0003\u001bBaa\u0012\bA\u0002\u0005\u001d\u0004\u0003BA5\u0003[j!!a\u001b\u000b\u0005\u001d;\u0018\u0002BA8\u0003W\u0012AAQ8es\u0006i1m\u001c8gS\u001e,(/\u001a\"pIf,\"!!\u001e\u0011\t\u0005]\u0014Q\u0010\b\u0004I\u0005e\u0014bAA>1\u0005A\"+Z9vKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\n\t\u0005}\u0014\u0011\u0011\u0002\u0018%\u0016\fX/Z:u\u0005VLG\u000eZ3s\u0007>tg-[4ve\u0016T1!a\u001f\u0019\u00039\u0019wN\u001c4jOV\u0014XMQ8es\u0002\nqcY8oM&<WO]3Qe&|'o\u00138po2,GmZ3\u00021\r|gNZ5hkJ,\u0007K]5pe.swn\u001e7fI\u001e,\u0007%A\fd_:4\u0017nZ;sKJ+\u0017/^3tiRKW.Z8viR!\u0011QRAJ!\rA\u0013qR\u0005\u0004\u0003#K#\u0001B+oSRDq!!\u0017\u0014\u0001\u0004\ti%\u0001\u0012d_:4\u0017nZ;sKJ+\u0017/^3ti\n+\u0018\u000e\u001c3fe\u001a{'\u000f\u0015:pi>\u001cw\u000e\\\u0001\u0018G>tg-[4ve\u0016\u001c\u0015m\u00195j]\u001eDU-\u00193feN$B!a'\u0002&R!\u0011QTAR!\u0011\ty%a(\n\u0007\u0005\u0005\u0006JA\u0004SKF,Xm\u001d;\t\rm)\u0002\u0019AAO\u0011\u0015\u0019X\u00031\u0001u\u0003\u0015\u0011W/\u001b7e+\t\tY\u000b\u0005\u0004\u0002.\u0006\u0005\u0017Q\u0014\b\u0005\u0003_\u000byL\u0004\u0003\u00022\u0006uf\u0002BAZ\u0003wsA!!.\u0002::\u0019a,a.\n\u0003\u0005J!a\b\u0011\n\u0005at\u0012BA:x\u0013\t\u0019g/\u0003\u0003\u0002D\u0006\u0015'AC#yaJ,7o]5p]*\u00111M\u001e")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge;

    private Validation<RequestBuilder> configureBodyParts(Session session, RequestBuilder requestBuilder, List<BodyPart> bodyParts) {
        return package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams(this.httpAttributes.formParams()), this.httpAttributes.form(), session).flatMap((Function1 & Serializable & scala.Serializable)params -> {
            Buffer stringParts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(params).asScala()).map((Function1 & Serializable & scala.Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null), Buffer$.MODULE$.canBuildFrom());
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts(bodyParts, session).map((Function1 & Serializable & scala.Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)stringParts.$plus$plus((GenTraversableOnce)parts, Buffer$.MODULE$.canBuildFrom())).asJava())));
        });
    }

    private Validation<RequestBuilder> setBody(Session session, RequestBuilder requestBuilder, Body body) {
        Validation validation;
        Body body2 = body;
        if (body2 instanceof StringBody) {
            StringBody stringBody = (StringBody)body2;
            Function1 string = stringBody.string();
            validation = ((Validation)string.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else if (body2 instanceof RawFileBody) {
            RawFileBody rawFileBody = (RawFileBody)body2;
            Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
            validation = ((Validation)resourceWithCachedBytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FileRequestBodyBuilder fileRequestBodyBuilder;
                ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                if (resourceAndCachedBytes != null) {
                    Resource resource = resourceAndCachedBytes.resource();
                    Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                    Option option = cachedBytes;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        fileRequestBodyBuilder = new ByteArrayRequestBodyBuilder(bytes, resource.name());
                    } else {
                        fileRequestBodyBuilder = new FileRequestBodyBuilder(resource.file());
                    }
                } else {
                    throw new MatchError((Object)resourceAndCachedBytes);
                }
                FileRequestBodyBuilder requestBodyBuilder = fileRequestBodyBuilder;
                RequestBuilder requestBuilder = requestBuilder.setBodyBuilder((RequestBodyBuilder)requestBodyBuilder);
                return requestBuilder;
            });
        } else if (body2 instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
            Function1 bytes = byteArrayBody.bytes();
            validation = ((Validation)bytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)b -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(b, null)));
        } else if (body2 instanceof ElBody) {
            ElBody elBody = (ElBody)body2;
            validation = ((Validation)elBody.asStringWithCachedBytes().apply((Object)session)).map((Function1 & Serializable & scala.Serializable)chunks -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringChunksRequestBodyBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(chunks).asJava())));
        } else if (body2 instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)body2;
            Function1 is2 = inputStreamBody.is();
            validation = ((Validation)is2.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)is -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new InputStreamRequestBodyBuilder(is)));
        } else if (body2 instanceof PebbleBody) {
            PebbleBody pebbleBody = (PebbleBody)body2;
            validation = pebbleBody.apply(session).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else {
            throw new MatchError((Object)body2);
        }
        return validation;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody() {
        return this.configureBody;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge() {
        return this.configurePriorKnowledge;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(((FiniteDuration)this.httpAttributes.requestTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.configuration.http().requestTimeout())).toMillis());
    }

    @Override
    public Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureRequestBuilderForProtocol() {
        return (Function1 & Serializable & scala.Serializable)session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> ((Validation)((Function1)this.configureBody().apply(session)).apply(requestBuilder)).flatMap((Function1)this.configurePriorKnowledge().apply(session));
    }

    private Request configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Function1<Session, Validation<Request>> build() {
        void var1_1;
        Function1<Session, Validation<Request>> exp = super.build();
        return this.httpProtocol.requestPart().cache() ? session -> ((Validation)exp.apply(session)).map((Function1 & Serializable & scala.Serializable)request -> this.configureCachingHeaders((Session)session, (Request)request)) : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$3(boolean x$2) {
        return x$2;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry == null) {
            throw new MatchError((Object)contentCacheEntry);
        }
        Option<String> etag = contentCacheEntry.etag();
        Option<String> lastModified = contentCacheEntry.lastModified();
        etag.foreach((Function1 & Serializable & scala.Serializable)x$3 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$3));
        lastModified.foreach((Function1 & Serializable & scala.Serializable)x$4 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$4));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> function1;
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Can't have both a body and body parts!");
        Option<Body> option = httpAttributes.body();
        if (option instanceof Some) {
            Some some = (Some)option;
            Body body = (Body)some.value();
            function1 = session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.setBody((Session)session, (RequestBuilder)requestBuilder, body);
        } else {
            function1 = httpAttributes.bodyParts().nonEmpty() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.configureBodyParts((Session)session, (RequestBuilder)requestBuilder, $this.httpAttributes.bodyParts()) : (httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams($this.httpAttributes.formParams()), $this.httpAttributes.form(), (Session)session).map((Function1 & Serializable & scala.Serializable)resolvedFormParams -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(resolvedFormParams))) : RequestExpressionBuilder$.MODULE$.ConfigureIdentity());
        }
        this.configureBody = function1;
        this.configurePriorKnowledge = httpProtocol.enginePart().enableHttp2() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> {
            Option<Object> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge((Session)session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$3(BoxesRunTime.unboxToBoolean((Object)x$2))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        } : RequestExpressionBuilder$.MODULE$.ConfigureIdentity();
    }
}

