/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.util.NameGen;
import io.gatling.jms.action.JmsLogging;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTrackerPool$;
import io.gatling.jms.client.MessageReceived;
import io.gatling.jms.client.Tracker$;
import io.gatling.jms.protocol.JmsMessageMatcher;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001ds!B\b\u0011\u0011\u0003Ib!B\u000e\u0011\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003bB\u0013\u0002\u0005\u0004%IA\n\u0005\u0007c\u0005\u0001\u000b\u0011B\u0014\u0007\tm\u0001\u0002A\r\u0005\t\u0001\u0016\u0011\t\u0011)A\u0005\u0003\"AA)\u0002B\u0001B\u0003%Q\t\u0003\u0005N\u000b\t\u0005\t\u0015!\u0003O\u0011!!VA!A!\u0002\u0013)\u0006\u0002\u0003/\u0006\u0005\u0003\u0005\u000b\u0011B/\t\u000b\r*A\u0011A2\t\u000f),!\u0019!C\u0005W\"9\u0011qD\u0003!\u0002\u0013a\u0007bBA\u0011\u000b\u0011\u0005\u00111E\u0001\u000f\u00156\u001cHK]1dW\u0016\u0014\bk\\8m\u0015\t\t\"#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003'Q\t1A[7t\u0015\t)b#A\u0004hCRd\u0017N\\4\u000b\u0003]\t!![8\u0004\u0001A\u0011!$A\u0007\u0002!\tq!*\\:Ue\u0006\u001c7.\u001a:Q_>d7CA\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!G\u0001\u0019\u00156\u001c8i\u001c8tk6,'\u000f\u00165sK\u0006$g)Y2u_JLX#A\u0014\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013AC2p]\u000e,(O]3oi*\u0011A&L\u0001\u0005kRLGN\u0003\u0002/-\u0005)a.\u001a;us&\u0011\u0001'\u000b\u0002\u0015\t\u00164\u0017-\u001e7u)\"\u0014X-\u00193GC\u000e$xN]=\u00023)k7oQ8ogVlWM\u001d+ie\u0016\fGMR1di>\u0014\u0018\u0010I\n\u0005\u000bu\u0019\u0014\b\u0005\u00025o5\tQG\u0003\u00027%\u00051\u0011m\u0019;j_:L!\u0001O\u001b\u0003\u0015)k7\u000fT8hO&tw\r\u0005\u0002;}5\t1H\u0003\u0002-y)\u0011Q\bF\u0001\u0005G>\u0014X-\u0003\u0002@w\t9a*Y7f\u000f\u0016t\u0017aC:fgNLwN\u001c)p_2\u0004\"A\u0007\"\n\u0005\r\u0003\"A\u0004&ngN+7o]5p]B{w\u000e\\\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015!B1di>\u0014(\"\u0001&\u0002\t\u0005\\7.Y\u0005\u0003\u0019\u001e\u00131\"Q2u_J\u001c\u0016p\u001d;f[\u0006Y1\u000f^1ug\u0016sw-\u001b8f!\ty%+D\u0001Q\u0015\t\tF(A\u0003ti\u0006$8/\u0003\u0002T!\nY1\u000b^1ug\u0016sw-\u001b8f\u0003\u0015\u0019Gn\\2l!\t1&,D\u0001X\u0015\ta\u0003L\u0003\u0002Z)\u000591m\\7n_:\u001c\u0018BA.X\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011a,Y\u0007\u0002?*\u0011\u0001\rP\u0001\u0007G>tg-[4\n\u0005\t|&\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0004eK\u001a<\u0007.\u001b\t\u00035\u0015AQ\u0001Q\u0006A\u0002\u0005CQ\u0001R\u0006A\u0002\u0015CQ!T\u0006A\u00029CQ\u0001V\u0006A\u0002UCQ\u0001X\u0006A\u0002u\u000b\u0001\u0002\u001e:bG.,'o]\u000b\u0002YB)QN\u001d;\u0002\u001a5\taN\u0003\u0002+_*\u0011A\u0006\u001d\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019hNA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004BAH;x}&\u0011ao\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005adX\"A=\u000b\u0005MQ(\"A>\u0002\u000b)\fg/\u0019=\n\u0005uL(a\u0003#fgRLg.\u0019;j_:\u0004BAH@\u0002\u0004%\u0019\u0011\u0011A\u0010\u0003\r=\u0003H/[8o!\u0011\t)!a\u0005\u000f\t\u0005\u001d\u0011q\u0002\t\u0004\u0003\u0013yRBAA\u0006\u0015\r\ti\u0001G\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Eq$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#y\u0002c\u0001\u000e\u0002\u001c%\u0019\u0011Q\u0004\t\u0003\u0015)k7\u000f\u0016:bG.,'/A\u0005ue\u0006\u001c7.\u001a:tA\u00059AO]1dW\u0016\u0014HCCA\r\u0003K\tI#!\f\u00028!1\u0011q\u0005\bA\u0002]\f1\u0002Z3ti&t\u0017\r^5p]\"1\u00111\u0006\bA\u0002y\f\u0001b]3mK\u000e$xN\u001d\u0005\b\u0003_q\u0001\u0019AA\u0019\u0003Ma\u0017n\u001d;f]\u0016\u0014H\u000b\u001b:fC\u0012\u001cu.\u001e8u!\rq\u00121G\u0005\u0004\u0003ky\"aA%oi\"9\u0011\u0011\b\bA\u0002\u0005m\u0012AD7fgN\fw-Z'bi\u000eDWM\u001d\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\n\u0002\u0011A\u0014x\u000e^8d_2LA!!\u0012\u0002@\t\t\"*\\:NKN\u001c\u0018mZ3NCR\u001c\u0007.\u001a:")
public class JmsTrackerPool
implements JmsLogging,
NameGen {
    private final JmsSessionPool sessionPool;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final ConcurrentHashMap<Tuple2<Destination, Option<String>>, JmsTracker> trackers;
    private Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void logMessage(Function0<String> text, Message msg) {
        JmsLogging.logMessage$(this, text, msg);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<Tuple2<Destination, Option<String>>, JmsTracker> trackers() {
        return this.trackers;
    }

    public JmsTracker tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackers().computeIfAbsent((Tuple2<Destination, Option<String>>)new Tuple2((Object)destination, selector), x$1 -> {
            ActorRef actor = $this.system.actorOf(Tracker$.MODULE$.props($this.statsEngine, $this.clock, $this.configuration), this.genName("jmsTrackerActor"));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), listenerThreadCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                int n = x$2;
                Thread thread = JmsTrackerPool$.MODULE$.io$gatling$jms$client$JmsTrackerPool$$JmsConsumerThreadFactory().newThread(() -> {
                    MessageConsumer consumer = $this.sessionPool.jmsSession().createConsumer(destination, (String)selector.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    consumer.setMessageListener(message -> {
                        String matchId = messageMatcher.responseMatchId(message);
                        this.logMessage((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Message received JMSMessageID=").append(message.getJMSMessageID()).append(" matchId=").append(matchId).toString(), message);
                        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
                        MessageReceived x$1 = new MessageReceived(matchId, $this.clock.nowMillis(), message);
                        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                        qual$1.$bang((Object)x$1, x$2);
                    });
                });
                thread.start();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            return new JmsTracker(actor);
        });
    }

    public JmsTrackerPool(JmsSessionPool sessionPool, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.sessionPool = sessionPool;
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        JmsLogging.$init$(this);
        NameGen.$init$((NameGen)this);
        this.trackers = new ConcurrentHashMap();
        Statics.releaseFence();
    }
}

