/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.gatling.jsonpath.AST;
import io.gatling.jsonpath.AST$AnyField$;
import io.gatling.jsonpath.AST$ArraySlice$;
import io.gatling.jsonpath.AST$CurrentNode$;
import io.gatling.jsonpath.AST$RecursiveAnyField$;
import io.gatling.jsonpath.AST$RootNode$;
import io.gatling.jsonpath.BinaryBooleanOperator;
import io.gatling.jsonpath.ComparisonOperator;
import io.gatling.jsonpath.RecursiveDataIterator;
import io.gatling.jsonpath.RecursiveFieldIterator;
import io.gatling.jsonpath.RecursiveNodeIterator;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q4A!\u0003\u0006\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0019)\u0005\u0001)C\u0005\u0015\"1A\f\u0001Q\u0005\nuCaa\u0019\u0001!\n\u0013!\u0007B\u00027\u0001A\u0013%QN\u0001\bKg>t\u0007+\u0019;i/\u0006d7.\u001a:\u000b\u0005-a\u0011\u0001\u00036t_:\u0004\u0018\r\u001e5\u000b\u00055q\u0011aB4bi2Lgn\u001a\u0006\u0002\u001f\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VMZ\u0001\te>|GOT8eKB\u0011!dI\u0007\u00027)\u0011A$H\u0001\tI\u0006$\u0018MY5oI*\u0011adH\u0001\bU\u0006\u001c7n]8o\u0015\t\u0001\u0013%A\u0005gCN$XM\u001d=nY*\t!%A\u0002d_6L!\u0001J\u000e\u0003\u0011)\u001bxN\u001c(pI\u0016\f\u0001BZ;mYB\u000bG\u000f\u001b\t\u0004O=\u0012dB\u0001\u0015.\u001d\tIC&D\u0001+\u0015\tY\u0003#\u0001\u0004=e>|GOP\u0005\u0002+%\u0011a\u0006F\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0014G\u0001\u0003MSN$(B\u0001\u0018\u0015!\t\u0019DH\u0004\u00025u9\u0011Q'\u000f\b\u0003mar!!K\u001c\n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u001e\u000b\u0003\r\t5\u000bV\u0005\u0003{y\u0012\u0011\u0002U1uQR{7.\u001a8\u000b\u0005mR\u0011A\u0002\u001fj]&$h\bF\u0002B\u0007\u0012\u0003\"A\u0011\u0001\u000e\u0003)AQ\u0001G\u0002A\u0002eAQ!J\u0002A\u0002\u0019\nAa^1mWR\tq\tE\u0002(\u0011fI!!S\u0019\u0003\u0011%#XM]1u_J$2aR&N\u0011\u0015aU\u00011\u0001\u001a\u0003\u0011qw\u000eZ3\t\u000b9+\u0001\u0019\u0001\u0014\u0002\u000bE,XM]=)\t\u0015\u0001\u0006,\u0017\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7/A\u0003wC2,X\rL\u0001[C\u0005Y\u0016aH8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018SK\u000e,(o]5p]\u0006)q/\u00197lcQ!qIX0b\u0011\u0015ae\u00011\u0001\u001a\u0011\u0015\u0001g\u00011\u00013\u0003%\tX/\u001a:z\u0011\u0016\fG\rC\u0003c\r\u0001\u0007a%A\u0005rk\u0016\u0014\u0018\u0010V1jY\u0006Y\u0011\r\u001d9ms\u001aKG\u000e^3s)\r9Um\u001a\u0005\u0006M\u001e\u0001\r!G\u0001\fGV\u0014(/\u001a8u\u001d>$W\rC\u0003i\u000f\u0001\u0007\u0011.A\u0006gS2$XM\u001d+pW\u0016t\u0007CA\u001ak\u0013\tYgHA\u0006GS2$XM\u001d+pW\u0016t\u0017AC:mS\u000e,\u0017I\u001d:bsR)qI\u001c9yu\")q\u000e\u0003a\u00013\u0005)\u0011M\u001d:bs\")\u0011\u000f\u0003a\u0001e\u0006)1\u000f^1siB\u00191c];\n\u0005Q$\"AB(qi&|g\u000e\u0005\u0002\u0014m&\u0011q\u000f\u0006\u0002\u0004\u0013:$\b\"B=\t\u0001\u0004\u0011\u0018\u0001B:u_BDQa\u001f\u0005A\u0002U\fAa\u001d;fa\u0002")
public class JsonPathWalker {
    private final JsonNode rootNode;
    private final List<AST.PathToken> fullPath;

    public Iterator<JsonNode> walk() {
        return this.walk(this.rootNode, this.fullPath);
    }

    private Iterator<JsonNode> walk(JsonNode node, List<AST.PathToken> query) {
        Iterator<JsonNode> iterator;
        List<AST.PathToken> list = query;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            AST.PathToken head = (AST.PathToken)colon2.head();
            List tail = colon2.next$access$1();
            iterator = this.walk1(node, head, (List<AST.PathToken>)tail);
        } else {
            iterator = scala.package$.MODULE$.Iterator().single((Object)node);
        }
        return iterator;
    }

    private Iterator<JsonNode> walk1(JsonNode node, AST.PathToken queryHead, List<AST.PathToken> queryTail) {
        Iterator iterator;
        AST.PathToken pathToken = queryHead;
        if (AST$RootNode$.MODULE$.equals(pathToken)) {
            iterator = this.walk(this.rootNode, queryTail);
        } else if (AST$CurrentNode$.MODULE$.equals(pathToken)) {
            iterator = this.walk(node, queryTail);
        } else if (pathToken instanceof AST.Field) {
            AST.Field field = (AST.Field)pathToken;
            String name2 = field.name();
            JsonNode child = node.get(name2);
            iterator = child == null ? scala.package$.MODULE$.Iterator().empty() : this.walk(child, queryTail);
        } else if (pathToken instanceof AST.RecursiveField) {
            AST.RecursiveField recursiveField = (AST.RecursiveField)pathToken;
            String name3 = recursiveField.name();
            iterator = new RecursiveFieldIterator(node, name3).flatMap((Function1 & Serializable)x$2 -> this.walk((JsonNode)x$2, queryTail));
        } else if (pathToken instanceof AST.MultiField) {
            AST.MultiField multiField = (AST.MultiField)pathToken;
            List<String> fieldNames = multiField.names();
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType2 = JsonNodeType.OBJECT;
            iterator = !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType2) : jsonNodeType2 != null) ? fieldNames.iterator().flatMap((Function1 & Serializable)name -> {
                JsonNode child = node.get(name);
                return child == null ? scala.package$.MODULE$.Iterator().empty() : this.walk(child, queryTail);
            }) : scala.package$.MODULE$.Iterator().empty();
        } else if (AST$AnyField$.MODULE$.equals(pathToken)) {
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType3 = JsonNodeType.OBJECT;
            iterator = !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType3) : jsonNodeType3 != null) ? CollectionConverters$.MODULE$.IteratorHasAsScala(node.elements()).asScala().flatMap((Function1 & Serializable)x$3 -> this.walk((JsonNode)x$3, queryTail)) : scala.package$.MODULE$.Iterator().empty();
        } else {
            AST.ArraySlice arraySlice = AST$ArraySlice$.MODULE$.All();
            AST.PathToken pathToken2 = pathToken;
            if (!(arraySlice != null ? !((Object)arraySlice).equals(pathToken2) : pathToken2 != null)) {
                JsonNodeType jsonNodeType = node.getNodeType();
                JsonNodeType jsonNodeType4 = JsonNodeType.ARRAY;
                iterator = !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType4) : jsonNodeType4 != null) ? CollectionConverters$.MODULE$.IteratorHasAsScala(node.elements()).asScala().flatMap((Function1 & Serializable)x$4 -> this.walk((JsonNode)x$4, queryTail)) : scala.package$.MODULE$.Iterator().empty();
            } else if (pathToken instanceof AST.ArraySlice) {
                AST.ArraySlice arraySlice2 = (AST.ArraySlice)pathToken;
                Option<Object> start = arraySlice2.start();
                Option<Object> stop = arraySlice2.stop();
                int step = arraySlice2.step();
                JsonNodeType jsonNodeType = node.getNodeType();
                JsonNodeType jsonNodeType5 = JsonNodeType.ARRAY;
                iterator = !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType5) : jsonNodeType5 != null) ? this.sliceArray(node, start, stop, step).flatMap((Function1 & Serializable)x$5 -> this.walk((JsonNode)x$5, queryTail)) : scala.package$.MODULE$.Iterator().empty();
            } else if (pathToken instanceof AST.ArrayRandomAccess) {
                AST.ArrayRandomAccess arrayRandomAccess = (AST.ArrayRandomAccess)pathToken;
                List<Object> indices = arrayRandomAccess.indices();
                JsonNodeType jsonNodeType = node.getNodeType();
                JsonNodeType jsonNodeType6 = JsonNodeType.ARRAY;
                iterator = !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType6) : jsonNodeType6 != null) ? indices.iterator().collect((PartialFunction)new Serializable(null, node){
                    private static final long serialVersionUID = 0L;
                    private final JsonNode node$1;

                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        switch (A1) {
                            default: 
                        }
                        return (B1)(A1 >= false && A1 < this.node$1.size() ? this.node$1.get(A1) : (A1 < false && A1 >= -this.node$1.size() ? this.node$1.get((int)(A1 + this.node$1.size())) : function1.apply((Object)BoxesRunTime.boxToInteger(x1))));
                    }

                    public final boolean isDefinedAt(int x1) {
                        int n = x1;
                        switch (n) {
                            default: 
                        }
                        return n >= 0 && n < this.node$1.size() ? true : n < 0 && n >= -this.node$1.size();
                    }
                    {
                        this.node$1 = node$1;
                    }
                }).flatMap((Function1 & Serializable)x$6 -> this.walk((JsonNode)x$6, queryTail)) : scala.package$.MODULE$.Iterator().empty();
            } else if (pathToken instanceof AST.RecursiveFilterToken) {
                AST.RecursiveFilterToken recursiveFilterToken = (AST.RecursiveFilterToken)pathToken;
                AST.FilterToken filterToken = recursiveFilterToken.filter();
                iterator = new RecursiveDataIterator(node).flatMap((Function1 & Serializable)x$7 -> this.applyFilter((JsonNode)x$7, filterToken)).flatMap((Function1 & Serializable)x$8 -> this.walk((JsonNode)x$8, queryTail));
            } else if (pathToken instanceof AST.FilterToken) {
                AST.FilterToken filterToken = (AST.FilterToken)pathToken;
                iterator = this.applyFilter(node, filterToken).flatMap((Function1 & Serializable)x$9 -> this.walk((JsonNode)x$9, queryTail));
            } else if (AST$RecursiveAnyField$.MODULE$.equals(pathToken)) {
                iterator = new RecursiveNodeIterator(node).flatMap((Function1 & Serializable)x$10 -> this.walk((JsonNode)x$10, queryTail));
            } else {
                throw new MatchError((Object)pathToken);
            }
        }
        return iterator;
    }

    private Iterator<JsonNode> applyFilter(JsonNode currentNode, AST.FilterToken filterToken) {
        return JsonPathWalker.elementsToFilter$1(currentNode).filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)this.evaluateFilter$1(x$13, filterToken)));
    }

    private Iterator<JsonNode> sliceArray(JsonNode array, Option<Object> start, Option<Object> stop, int step) {
        int n;
        int n2;
        int size = array.size();
        Option<Object> option = start;
        if (option instanceof Some) {
            Some some = (Some)option;
            int v = BoxesRunTime.unboxToInt((Object)some.value());
            n2 = JsonPathWalker.relative$1(v, size, step);
        } else {
            n2 = 0;
        }
        int absStart = n2;
        Option<Object> option2 = stop;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int v = BoxesRunTime.unboxToInt((Object)some.value());
            n = JsonPathWalker.relative$1(v, size, step);
        } else {
            n = size;
        }
        int absEnd = n;
        int absStep = package$.MODULE$.abs(step);
        Iterator elements = step < 0 ? scala.package$.MODULE$.Iterator().range(array.size() - 1, -1, -1).map((Function1 & Serializable)x$1 -> array.get(BoxesRunTime.unboxToInt((Object)x$1))) : CollectionConverters$.MODULE$.IteratorHasAsScala(array.elements()).asScala();
        Iterator fromStartToEnd = elements.slice(absStart, absEnd);
        return absStep == 1 ? fromStartToEnd : fromStartToEnd.grouped(absStep).map((Function1 & Serializable)x$14 -> (JsonNode)x$14.head());
    }

    private final boolean resolveSubQuery$1(JsonNode node, List subQuery, Function1 nextOp) {
        Iterator<JsonNode> it = this.walk(node, (List<AST.PathToken>)subQuery);
        return it.hasNext() && BoxesRunTime.unboxToBoolean((Object)nextOp.apply(it.next()));
    }

    private final boolean applyBinaryOpWithResolvedLeft$1(JsonNode node, ComparisonOperator op, JsonNode lhsNode, AST.FilterValue rhs) {
        boolean bl;
        AST.FilterValue filterValue = rhs;
        if (filterValue instanceof AST.FilterDirectValue) {
            AST.FilterDirectValue filterDirectValue = (AST.FilterDirectValue)filterValue;
            JsonNode valueNode = filterDirectValue.node();
            bl = op.apply(lhsNode, valueNode);
        } else if (filterValue instanceof AST.SubQuery) {
            AST.SubQuery subQuery = (AST.SubQuery)filterValue;
            List<AST.PathToken> subQuery2 = subQuery.path();
            bl = this.resolveSubQuery$1(node, subQuery2, (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)op.apply(lhsNode, x$11)));
        } else {
            throw new MatchError((Object)filterValue);
        }
        return bl;
    }

    private final boolean applyBinaryOp$1(JsonNode node, ComparisonOperator op, AST.FilterValue lhs, AST.FilterValue rhs) {
        boolean bl;
        AST.FilterValue filterValue = lhs;
        if (filterValue instanceof AST.FilterDirectValue) {
            AST.FilterDirectValue filterDirectValue = (AST.FilterDirectValue)filterValue;
            JsonNode valueNode = filterDirectValue.node();
            bl = this.applyBinaryOpWithResolvedLeft$1(node, op, valueNode, rhs);
        } else if (filterValue instanceof AST.SubQuery) {
            AST.SubQuery subQuery = (AST.SubQuery)filterValue;
            List<AST.PathToken> subQuery2 = subQuery.path();
            bl = this.resolveSubQuery$1(node, subQuery2, (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)this.applyBinaryOpWithResolvedLeft$1(node, op, x$12, rhs)));
        } else {
            throw new MatchError((Object)filterValue);
        }
        return bl;
    }

    private static final Iterator elementsToFilter$1(JsonNode node) {
        JsonNodeType jsonNodeType = node.getNodeType();
        Iterator iterator = JsonNodeType.ARRAY.equals(jsonNodeType) ? CollectionConverters$.MODULE$.IteratorHasAsScala(node.elements()).asScala() : (JsonNodeType.OBJECT.equals(jsonNodeType) ? scala.package$.MODULE$.Iterator().single((Object)node) : scala.package$.MODULE$.Iterator().empty());
        return iterator;
    }

    private final boolean evaluateFilter$1(JsonNode node, AST.FilterToken filterToken) {
        boolean bl;
        AST.FilterToken filterToken2 = filterToken;
        if (filterToken2 instanceof AST.HasFilter) {
            AST.HasFilter hasFilter = (AST.HasFilter)filterToken2;
            AST.SubQuery subQuery = hasFilter.query();
            bl = this.walk(node, subQuery.path()).hasNext();
        } else if (filterToken2 instanceof AST.ComparisonFilter) {
            AST.ComparisonFilter comparisonFilter = (AST.ComparisonFilter)filterToken2;
            ComparisonOperator op = comparisonFilter.operator();
            AST.FilterValue lhs = comparisonFilter.lhs();
            AST.FilterValue rhs = comparisonFilter.rhs();
            bl = this.applyBinaryOp$1(node, op, lhs, rhs);
        } else if (filterToken2 instanceof AST.BooleanFilter) {
            AST.BooleanFilter booleanFilter = (AST.BooleanFilter)filterToken2;
            BinaryBooleanOperator op = booleanFilter.operator();
            AST.FilterToken filter1 = booleanFilter.lhs();
            AST.FilterToken filter2 = booleanFilter.rhs();
            boolean f1 = this.evaluateFilter$1(node, filter1);
            boolean f2 = this.evaluateFilter$1(node, filter2);
            bl = op.apply(f1, f2);
        } else {
            throw new MatchError((Object)filterToken2);
        }
        return bl;
    }

    private static final int lenRelative$1(int x, int size$1) {
        return x >= 0 ? x : size$1 + x;
    }

    private static final int stepRelative$1(int x, int step$1) {
        return step$1 >= 0 ? x : -1 - x;
    }

    private static final int relative$1(int x, int size$1, int step$1) {
        return JsonPathWalker.lenRelative$1(JsonPathWalker.stepRelative$1(x, step$1), size$1);
    }

    public JsonPathWalker(JsonNode rootNode, List<AST.PathToken> fullPath) {
        this.rootNode = rootNode;
        this.fullPath = fullPath;
    }
}

