/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public final class Transports {
    private static final ChannelFactory<? extends SocketChannel> EPOLL_SOCKET_CHANNEL_FACTORY = EpollSocketChannel::new;
    private static final ChannelFactory<? extends SocketChannel> IOURING_SOCKET_CHANNEL_FACTORY = IoUringSocketChannel::new;
    private static final ChannelFactory<? extends SocketChannel> NIO_SOCKET_CHANNEL_FACTORY = NioSocketChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> EPOLL_DATAGRAM_CHANNEL_FACTORY = EpollDatagramChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> IOURING_DATAGRAM_CHANNEL_FACTORY = IoUringDatagramChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> NIO_DATAGRAM_CHANNEL_FACTORY = NioDatagramChannel::new;

    private Transports() {
    }

    public static EventLoopGroup newEventLoopGroup(boolean bl, boolean bl2, int n, String string) {
        DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
        IoHandlerFactory ioHandlerFactory = null;
        if (bl) {
            if (bl2 && IoUring.isAvailable()) {
                ioHandlerFactory = IoUringIoHandler.newFactory();
            } else if (Epoll.isAvailable()) {
                ioHandlerFactory = EpollIoHandler.newFactory();
            }
        }
        if (ioHandlerFactory == null) {
            ioHandlerFactory = NioIoHandler.newFactory();
        }
        return new MultiThreadIoEventLoopGroup(n, (ThreadFactory)defaultThreadFactory, ioHandlerFactory);
    }

    public static ChannelFactory<? extends SocketChannel> newSocketChannelFactory(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && IoUring.isAvailable()) {
                return IOURING_SOCKET_CHANNEL_FACTORY;
            }
            if (Epoll.isAvailable()) {
                return EPOLL_SOCKET_CHANNEL_FACTORY;
            }
        }
        return NIO_SOCKET_CHANNEL_FACTORY;
    }

    public static ChannelFactory<? extends DatagramChannel> newDatagramChannelFactory(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2 && IoUring.isAvailable()) {
                return IOURING_DATAGRAM_CHANNEL_FACTORY;
            }
            if (Epoll.isAvailable()) {
                return EPOLL_DATAGRAM_CHANNEL_FACTORY;
            }
        }
        return NIO_DATAGRAM_CHANNEL_FACTORY;
    }

    public static void configureOptions(Bootstrap bootstrap, int n, boolean bl, boolean bl2, boolean bl3) {
        ((Bootstrap)((Bootstrap)bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)n)).option(ChannelOption.TCP_NODELAY, (Object)bl)).option(ChannelOption.SO_KEEPALIVE, (Object)bl2);
    }
}

