/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.operator.bc;

import io.gatling.recorder.internal.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.crypto.Signer;
import io.gatling.recorder.internal.bouncycastle.crypto.signers.Ed25519Signer;
import io.gatling.recorder.internal.bouncycastle.operator.OperatorCreationException;
import io.gatling.recorder.internal.bouncycastle.operator.bc.BcContentSignerBuilder;

public class BcEdECContentSignerBuilder
extends BcContentSignerBuilder {
    public BcEdECContentSignerBuilder(AlgorithmIdentifier algorithmIdentifier) {
        super(algorithmIdentifier, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512));
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(EdECObjectIdentifiers.id_Ed25519)) {
            return new Ed25519Signer();
        }
        throw new IllegalStateException("unknown signature type");
    }
}

