/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.util.io.pem;

import io.gatling.recorder.internal.bouncycastle.util.encoders.Base64;
import io.gatling.recorder.internal.bouncycastle.util.io.pem.PemHeader;
import io.gatling.recorder.internal.bouncycastle.util.io.pem.PemObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class PemReader
extends BufferedReader {
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";

    public PemReader(Reader reader) {
        super(reader);
    }

    public PemObject readPemObject() throws IOException {
        int n;
        String string = this.readLine();
        while (string != null && !string.startsWith(BEGIN)) {
            string = this.readLine();
        }
        if (string != null && (n = (string = string.substring(BEGIN.length()).trim()).indexOf(45)) > 0 && string.endsWith("-----") && string.length() - n == 5) {
            String string2 = string.substring(0, n);
            return this.loadObject(string2);
        }
        return null;
    }

    private PemObject loadObject(String string) throws IOException {
        String string2;
        String string3 = END + string + "-----";
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<PemHeader> arrayList = new ArrayList<PemHeader>();
        while ((string2 = this.readLine()) != null) {
            int n = string2.indexOf(58);
            if (n >= 0) {
                String string4 = string2.substring(0, n);
                String string5 = string2.substring(n + 1).trim();
                arrayList.add(new PemHeader(string4, string5));
                continue;
            }
            if (string2.indexOf(string3) == 0) break;
            stringBuffer.append(string2.trim());
        }
        if (string2 == null) {
            throw new IOException(string3 + " not found");
        }
        return new PemObject(string, arrayList, Base64.decode(stringBuffer.toString()));
    }
}

