/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.dvcs;

import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.DVCSTime;
import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.Data;
import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.ServiceType;
import io.gatling.recorder.internal.bouncycastle.cms.CMSSignedData;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSException;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSRequest;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSRequestBuilder;
import java.io.IOException;
import java.util.Date;

public class VSDRequestBuilder
extends DVCSRequestBuilder {
    public VSDRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VSD));
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build(CMSSignedData cMSSignedData) throws DVCSException {
        try {
            Data data = new Data(cMSSignedData.getEncoded());
            return this.createDVCRequest(data);
        }
        catch (IOException iOException) {
            throw new DVCSException("Failed to encode CMS signed data", iOException);
        }
    }
}

