/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.cert.dane;

import io.gatling.recorder.internal.bouncycastle.cert.X509CertificateHolder;
import io.gatling.recorder.internal.bouncycastle.cert.dane.DANEEntry;
import io.gatling.recorder.internal.bouncycastle.cert.dane.DANEEntryFetcherFactory;
import io.gatling.recorder.internal.bouncycastle.cert.dane.DANEEntrySelector;
import io.gatling.recorder.internal.bouncycastle.cert.dane.DANEEntrySelectorFactory;
import io.gatling.recorder.internal.bouncycastle.cert.dane.DANEException;
import io.gatling.recorder.internal.bouncycastle.operator.DigestCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory dANEEntryFetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = dANEEntryFetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String string) throws DANEException {
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        List list = this.fetcherFactory.build(dANEEntrySelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(list.size());
        for (DANEEntry dANEEntry : list) {
            if (!dANEEntrySelector.match(dANEEntry)) continue;
            arrayList.add(dANEEntry.getCertificate());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

