/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc;

import io.gatling.recorder.internal.bouncycastle.crypto.EncapsulatedSecretExtractor;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.HQCEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.HQCKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.HQCParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;

public class HQCKEMExtractor
implements EncapsulatedSecretExtractor {
    private HQCEngine engine;
    private final HQCKeyParameters key;

    public HQCKEMExtractor(HQCPrivateKeyParameters hQCPrivateKeyParameters) {
        this.key = hQCPrivateKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(HQCParameters hQCParameters) {
        this.engine = hQCParameters.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        HQCPrivateKeyParameters hQCPrivateKeyParameters = (HQCPrivateKeyParameters)this.key;
        byte[] byArray3 = hQCPrivateKeyParameters.getPrivateKey();
        this.engine.decaps(byArray2, byArray, byArray3);
        return Arrays.copyOfRange(byArray2, 0, 32);
    }

    @Override
    public int getEncapsulationLength() {
        return this.key.getParameters().getN_BYTES() + this.key.getParameters().getN1N2_BYTES() + 16;
    }
}

