/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.swing;

import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.ui.FrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.swing.component.DialogFileSelector;
import io.gatling.recorder.ui.swing.frame.ConfigurationFrame;
import io.gatling.recorder.ui.swing.frame.RunningFrame;
import io.gatling.shared.util.PathHelper;
import io.gatling.shared.util.PathHelper$;
import java.io.Serializable;
import java.nio.file.Path;
import javax.swing.Icon;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.swing.Dialog;
import scala.swing.Dialog$;
import scala.swing.Swing;
import scala.swing.Swing$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb!\u0002\n\u0014\u0001Ui\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u0011%\u0002!\u0011!Q\u0001\n)BQ\u0001\r\u0001\u0005\u0002EB\u0001B\u000e\u0001\t\u0006\u0004%Ia\u000e\u0005\t}\u0001A)\u0019!C\u0005\u007f!)1\t\u0001C!\t\")\u0001\n\u0001C!\u0013\")A\u000b\u0001C!+\")Q\f\u0001C!=\")q\f\u0001C!A\")a\u000e\u0001C!_\")1\u0010\u0001C!y\"1\u0011\u0011\u0001\u0001\u0005ByCa!a\u0001\u0001\t\u0003r\u0006BBA\u0003\u0001\u0011\u0005c\fC\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\ti1k^5oO\u001a\u0013xN\u001c;F]\u0012T!\u0001F\u000b\u0002\u000bM<\u0018N\\4\u000b\u0005Y9\u0012AA;j\u0015\tA\u0012$\u0001\u0005sK\u000e|'\u000fZ3s\u0015\tQ2$A\u0004hCRd\u0017N\\4\u000b\u0003q\t!![8\u0014\u0005\u0001q\u0002CA\u0010!\u001b\u0005)\u0012BA\u0011\u0016\u0005A\u0011VmY8sI\u0016\u0014hI]8oi\u0016sG-\u0001\u0006d_:$(o\u001c7mKJ\u001c\u0001\u0001\u0005\u0002&O5\taE\u0003\u0002#/%\u0011\u0001F\n\u0002\u0013%\u0016\u001cwN\u001d3fe\u000e{g\u000e\u001e:pY2,'/A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003W9j\u0011\u0001\f\u0006\u0003[]\taaY8oM&<\u0017BA\u0018-\u0005U\u0011VmY8sI\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDc\u0001\u001a5kA\u00111\u0007A\u0007\u0002'!)!e\u0001a\u0001I!)\u0011f\u0001a\u0001U\u0005a!/\u001e8oS:<gI]1nKV\t\u0001\b\u0005\u0002:y5\t!H\u0003\u0002<'\u0005)aM]1nK&\u0011QH\u000f\u0002\r%Vtg.\u001b8h\rJ\fW.Z\u0001\u0013G>tg-[4ve\u0006$\u0018n\u001c8Ge\u0006lW-F\u0001A!\tI\u0014)\u0003\u0002Cu\t\u00112i\u001c8gS\u001e,(/\u0019;j_:4%/Y7f\u0003Q\u0019X\r\\3di\u0016$'+Z2pe\u0012,'/T8eKV\tQ\t\u0005\u0002,\r&\u0011q\t\f\u0002\r%\u0016\u001cwN\u001d3fe6{G-Z\u0001\fQ\u0006\u0014h)\u001b7f!\u0006$\b.F\u0001K!\tY%+D\u0001M\u0015\tie*\u0001\u0003gS2,'BA(Q\u0003\rq\u0017n\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019FJ\u0001\u0003QCRD\u0017\u0001\u00065b]\u0012dW-T5tg&tw\rS1s\r&dW\r\u0006\u0002W9B\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n!QK\\5u\u0011\u0015A\u0005\u00021\u0001K\u0003YA\u0017M\u001c3mK\"\u000b'/\u0012=q_J$8+^2dKN\u001cH#\u0001,\u0002-!\fg\u000e\u001a7f\u0011\u0006\u0014X\t\u001f9peR4\u0015-\u001b7ve\u0016$\"AV1\t\u000b\tT\u0001\u0019A2\u0002\u000f5,7o]1hKB\u0011Am\u001b\b\u0003K&\u0004\"A\u001a-\u000e\u0003\u001dT!\u0001[\u0012\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0007,\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016Y\u0003yA\u0017M\u001c3mK\u001aKG\u000e^3s-\u0006d\u0017\u000eZ1uS>tg)Y5mkJ,7\u000f\u0006\u0002Wa\")\u0011o\u0003a\u0001e\u0006Aa-Y5mkJ,7\u000fE\u0002tq\u000et!\u0001\u001e<\u000f\u0005\u0019,\u0018\"A-\n\u0005]D\u0016a\u00029bG.\fw-Z\u0005\u0003sj\u00141aU3r\u0015\t9\b,\u0001\fbg.\u001c\u0016.\\;mCRLwN\\(wKJ<(/\u001b;f+\u0005i\bCA,\u007f\u0013\ty\bLA\u0004C_>dW-\u00198\u0002\t%t\u0017\u000e^\u0001\u0011e\u0016\u001cwN\u001d3j]\u001e\u001cF/\u0019:uK\u0012\f\u0001C]3d_J$\u0017N\\4Ti>\u0004\b/\u001a3\u0002\u0019I,7-Z5wK\u00163XM\u001c;\u0015\u0007Y\u000bY\u0001C\u0004\u0002\u000eA\u0001\r!a\u0004\u0002\u000b\u00154XM\u001c;\u0011\u0007}\t\t\"C\u0002\u0002\u0014U\u0011QB\u0012:p]R,e\u000eZ#wK:$\u0018a\u00037p_.,\bOR5mKN$B!!\u0007\u0002 A!1/a\u0007d\u0013\r\tiB\u001f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004\u0002\"E\u0001\rAS\u0001\u0005a\u0006$\b\u000e")
public class SwingFrontEnd
extends RecorderFrontEnd {
    private RunningFrame runningFrame;
    private ConfigurationFrame configurationFrame;
    private RecorderConfiguration configuration;
    private volatile byte bitmap$0;

    private RunningFrame runningFrame$lzycompute() {
        SwingFrontEnd swingFrontEnd = this;
        synchronized (swingFrontEnd) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.runningFrame = new RunningFrame(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.runningFrame;
    }

    private RunningFrame runningFrame() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.runningFrame$lzycompute();
        }
        return this.runningFrame;
    }

    private ConfigurationFrame configurationFrame$lzycompute() {
        SwingFrontEnd swingFrontEnd = this;
        synchronized (swingFrontEnd) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.configurationFrame = new ConfigurationFrame(this, this.configuration);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.configuration = null;
        return this.configurationFrame;
    }

    private ConfigurationFrame configurationFrame() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.configurationFrame$lzycompute();
        }
        return this.configurationFrame;
    }

    @Override
    public RecorderMode selectedRecorderMode() {
        return this.configurationFrame().selectedRecorderMode();
    }

    @Override
    public Path harFilePath() {
        return this.configurationFrame().harFilePath();
    }

    @Override
    public void handleMissingHarFile(Path harFilePath) {
        if (((Object)harFilePath).toString().isEmpty()) {
            String x$1 = "Error";
            String x$2 = "You haven't selected an HAR file.";
            Enumeration.Value x$3 = Dialog.Message$.MODULE$.Error();
            Swing.PeerContainer x$4 = Dialog$.MODULE$.showMessage$default$1();
            Icon x$5 = Dialog$.MODULE$.showMessage$default$5();
            Dialog$.MODULE$.showMessage(x$4, (Object)"You haven't selected an HAR file.", "Error", x$3, x$5);
            return;
        }
        List<String> possibleMatches = this.lookupFiles(harFilePath);
        if (possibleMatches.isEmpty()) {
            String x$6 = "No matches found";
            String x$7 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|No files that could closely match the\n                       |selected file's name have been found.\n                       |Please check the file's path is correct."));
            Enumeration.Value x$8 = Dialog.Message$.MODULE$.Warning();
            Swing.PeerContainer x$9 = Dialog$.MODULE$.showMessage$default$1();
            Icon x$10 = Dialog$.MODULE$.showMessage$default$5();
            Dialog$.MODULE$.showMessage(x$9, (Object)x$7, "No matches found", x$8, x$10);
            return;
        }
        DialogFileSelector selector = new DialogFileSelector(this.configurationFrame(), possibleMatches);
        selector.open();
        Path parentPath = harFilePath.getParent();
        this.configurationFrame().updateHarFilePath((Option<Path>)selector.selectedFile().map((Function1 & Serializable)file -> parentPath.resolve((String)file)));
    }

    @Override
    public void handleHarExportSuccess() {
        String x$1 = "Conversion complete";
        String x$2 = "Successfully converted HAR file to a Gatling simulation";
        Enumeration.Value x$3 = Dialog.Message$.MODULE$.Info();
        Swing.PeerContainer x$4 = Dialog$.MODULE$.showMessage$default$1();
        Icon x$5 = Dialog$.MODULE$.showMessage$default$5();
        Dialog$.MODULE$.showMessage(x$4, (Object)"Successfully converted HAR file to a Gatling simulation", "Conversion complete", x$3, x$5);
    }

    @Override
    public void handleHarExportFailure(String message) {
        String x$1 = "Error";
        String x$2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Export to HAR File unsuccessful: " + message + ".\n                    |See logs for more information"));
        Enumeration.Value x$3 = Dialog.Message$.MODULE$.Error();
        Swing.PeerContainer x$4 = Dialog$.MODULE$.showMessage$default$1();
        Icon x$5 = Dialog$.MODULE$.showMessage$default$5();
        Dialog$.MODULE$.showMessage(x$4, (Object)x$2, "Error", x$3, x$5);
    }

    @Override
    public void handleFilterValidationFailures(Seq<String> failures) {
        String x$1 = "Error";
        String x$2 = failures.mkString("\n");
        Enumeration.Value x$3 = Dialog.Message$.MODULE$.Error();
        Swing.PeerContainer x$4 = Dialog$.MODULE$.showMessage$default$1();
        Icon x$5 = Dialog$.MODULE$.showMessage$default$5();
        Dialog$.MODULE$.showMessage(x$4, (Object)x$2, "Error", x$3, x$5);
    }

    @Override
    public boolean askSimulationOverwrite() {
        String x$1 = "Warning";
        String x$2 = "You are about to overwrite an existing simulation.";
        Enumeration.Value x$3 = Dialog.Options$.MODULE$.OkCancel();
        Enumeration.Value x$4 = Dialog.Message$.MODULE$.Warning();
        Swing.PeerContainer x$5 = Dialog$.MODULE$.showConfirmation$default$1();
        Icon x$6 = Dialog$.MODULE$.showConfirmation$default$6();
        Enumeration.Value value = Dialog$.MODULE$.showConfirmation(x$5, (Object)"You are about to overwrite an existing simulation.", "Warning", x$3, x$4, x$6);
        Enumeration.Value value2 = Dialog.Result$.MODULE$.Ok();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    @Override
    public void init() {
        this.configurationFrame().visible_$eq(true);
        this.runningFrame().visible_$eq(false);
    }

    @Override
    public void recordingStarted() {
        this.runningFrame().visible_$eq(true);
        this.configurationFrame().visible_$eq(false);
    }

    @Override
    public void recordingStopped() {
        this.runningFrame().clearState();
    }

    @Override
    public void receiveEvent(FrontEndEvent event) {
        Swing$.MODULE$.onEDT((Function0)(JFunction0.mcV.sp & Serializable)() -> this.runningFrame().receiveEvent(event));
    }

    private List<String> lookupFiles(Path path) {
        Path parent = path.getParent();
        return ((IterableOnceOps)PathHelper$.MODULE$.files(parent).collect((PartialFunction)new Serializable(null, path){
            private static final long serialVersionUID = 0L;
            private final Path path$1;

            public final <A1 extends PathHelper.CachingPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.path().startsWith(this.path$1)) {
                    return (B1)A1.filename();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PathHelper.CachingPath x1) {
                PathHelper.CachingPath cachingPath = x1;
                return cachingPath.path().startsWith(this.path$1);
            }
            {
                this.path$1 = path$1;
            }
        })).toList();
    }

    public SwingFrontEnd(RecorderController controller, RecorderConfiguration configuration) {
        this.configuration = configuration;
        super(controller);
    }
}

