/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.UserSeries;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4QAD\b\u0003#eA\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t[\u0001\u0011\t\u0011)A\u0005A!Aa\u0006\u0001B\u0001B\u0003%\u0001\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!!\u0004A!A!\u0002\u0013)\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000f9\u0003!\u0019!C\u0005\u001f\"1a\f\u0001Q\u0001\nACQa\u0018\u0001\u0005B\u0001DQ!\u0019\u0001\u0005\n\tDqa\u001a\u0001C\u0002\u0013\u0005\u0003\r\u0003\u0004i\u0001\u0001\u0006I\u0001\t\u0002\u0013+N,'o]\"iCJ$H+Z7qY\u0006$XM\u0003\u0002\u0011#\u0005AA/Z7qY\u0006$XM\u0003\u0002\u0013'\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u0005Q)\u0012AB2iCJ$8O\u0003\u0002\u0017/\u00059q-\u0019;mS:<'\"\u0001\r\u0002\u0005%|7C\u0001\u0001\u001b!\tYB$D\u0001\u0010\u0013\tirB\u0001\u0005UK6\u0004H.\u0019;f\u0003\u0015!\u0018\u000e\u001e7f\u0007\u0001\u0001\"!\t\u0016\u000f\u0005\tB\u0003CA\u0012'\u001b\u0005!#BA\u0013 \u0003\u0019a$o\\8u})\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc%\u0001\u0006z\u0003bL7\u000fV5uY\u0016\f1bY8oi\u0006Lg.\u001a:JI\u0006A!/\u001e8Ti\u0006\u0014H\u000f\u0005\u00022e5\ta%\u0003\u00024M\t!Aj\u001c8h\u00039\tG\u000e\\+tKJ\u001c8+\u001a:jKN\u0004\"AN\u001d\u000e\u0003]R!\u0001O\n\u0002\u000bM$\u0018\r^:\n\u0005i:$AC+tKJ\u001cVM]5fg\u0006q1oY3oCJLwnU3sS\u0016\u001c\bcA\u001fCk9\u0011a\b\u0011\b\u0003G}J\u0011aJ\u0005\u0003\u0003\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002D\t\n\u00191+Z9\u000b\u0005\u00053\u0013A\u0002\u001fj]&$h\bF\u0004H\u0011&S5\nT'\u0011\u0005m\u0001\u0001\"\u0002\u0010\b\u0001\u0004\u0001\u0003\"B\u0017\b\u0001\u0004\u0001\u0003\"\u0002\u0018\b\u0001\u0004\u0001\u0003\"B\u0018\b\u0001\u0004\u0001\u0004\"\u0002\u001b\b\u0001\u0004)\u0004\"B\u001e\b\u0001\u0004a\u0014\u0001F:dK:\f'/[8TKJLWm]\"pY>\u00148/F\u0001Q!\r\tf\u000bW\u0007\u0002%*\u00111\u000bV\u0001\nS6lW\u000f^1cY\u0016T!!\u0016\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002X%\n!A*[:u!\tIF,D\u0001[\u0015\tY6#\u0001\u0003vi&d\u0017BA/[\u0005\u0015\u0019u\u000e\\8s\u0003U\u00198-\u001a8be&|7+\u001a:jKN\u001cu\u000e\\8sg\u0002\n!A[:\u0016\u0003\u0001\n!D]3oI\u0016\u0014Xk]3sgB+'oU3d_:$7+\u001a:jKN$2\u0001I2f\u0011\u0015!7\u00021\u00016\u0003\u0019\u0019XM]5fg\")am\u0003a\u00011\u0006)1m\u001c7pe\u0006!\u0001\u000e^7m\u0003\u0015AG/\u001c7!\u0001")
public final class UsersChartTemplate
extends Template {
    private final String title;
    private final String yAxisTitle;
    private final String containerId;
    private final long runStart;
    private final UserSeries allUsersSeries;
    private final Seq<UserSeries> scenarioSeries;
    private final List<Color> scenarioSeriesColors;
    private final String html;

    private List<Color> scenarioSeriesColors() {
        return this.scenarioSeriesColors;
    }

    @Override
    public String js() {
        return "\nnew Highcharts.StockChart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    zoomType: 'x'\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    align: 'right',\n    verticalAlign: 'top',\n    layout: 'vertical',\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.title + "</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false\n  },\n  rangeSelector: {\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '" + Color.RangeSelector$.Fill$.MODULE$ + "',\n      padding: 1,\n      stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n      'stroke-width': 0.25,\n      style: {\n        color: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n          style: { color: 'black' }\n        },\n        select: {\n          fill: '" + Color.RangeSelector$.MODULE$.Selected() + "',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis: {\n    title: { text: '" + this.yAxisTitle + "' },\n    opposite: false,\n    min: 0\n  },\n  series: [\n    " + ((IterableOnceOps)((IterableOps)this.scenarioSeries.zip(this.scenarioSeriesColors())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UserSeries series = (UserSeries)tuple2._1();
                Color color = (Color)tuple2._2();
                return this.renderUsersPerSecondSeries(series, color);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(",\n") + ",\n    " + this.renderUsersPerSecondSeries(this.allUsersSeries, Color.Users$.MODULE$.All()) + "\n  ]\n});\n";
    }

    private String renderUsersPerSecondSeries(UserSeries series, Color color) {
        return "{\ncolor: '" + color + "',\nname: '" + series.name().replace("'", "\\'") + "',\ndata: [\n  " + ((IterableOnceOps)series.data().map((Function1 & Serializable)plot -> "[" + this.truncateTimestampToSecond($this.runStart + (long)plot.time()) + ", " + plot.value() + "]")).mkString(",") + "\n],\ntooltip: { yDecimals: 0, ySuffix: '', valueDecimals: 0 }\n}";
    }

    @Override
    public String html() {
        return this.html;
    }

    public UsersChartTemplate(String title, String yAxisTitle, String containerId, long runStart, UserSeries allUsersSeries, Seq<UserSeries> scenarioSeries) {
        this.title = title;
        this.yAxisTitle = yAxisTitle;
        this.containerId = containerId;
        this.runStart = runStart;
        this.allUsersSeries = allUsersSeries;
        this.scenarioSeries = scenarioSeries;
        this.scenarioSeriesColors = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> Color.Users$.MODULE$.Base()).flatten(Predef$.MODULE$.$conforms()).take(scenarioSeries.size()).toList();
        this.html = "\n            <div class=\"schema geant\">\n              <div id=\"" + containerId + "\" class=\"geant\"></div>\n            </div>\n";
    }
}

