/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U3QAC\u0006\u0003\u001bUA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0011\b\u0001B\u0001B\u0003%!\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003\u001d\u0011!Y\u0004A!A!\u0002\u0013a\u0002\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002#\u0001\t\u0003*\u0005\"\u0002$\u0001\t\u00139\u0005\"\u0002+\u0001\t\u0003*%a\u0007*fgB|gn]3US6,7kY1ui\u0016\u0014H+Z7qY\u0006$XM\u0003\u0002\r\u001b\u0005AA/Z7qY\u0006$XM\u0003\u0002\u000f\u001f\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u0005A\t\u0012AB2iCJ$8O\u0003\u0002\u0013'\u00059q-\u0019;mS:<'\"\u0001\u000b\u0002\u0005%|7C\u0001\u0001\u0017!\t9\u0002$D\u0001\f\u0013\tI2B\u0001\u0005UK6\u0004H.\u0019;f\u0003-\u0019wN\u001c;bS:,'/\u00133\u0004\u0001A\u0011QD\n\b\u0003=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R!!I\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0005\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0012\u0013aB:vG\u000e,7o\u001d\t\u0004WA\u001adB\u0001\u0017/\u001d\tyR&C\u0001$\u0013\ty#%A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0012$aA*fc*\u0011qF\t\t\u0003i]j\u0011!\u000e\u0006\u0003m=\tQa\u001d;biNL!\u0001O\u001b\u0003\u001b%sGOV:US6,\u0007\u000b\\8u\u0003!1\u0017-\u001b7ve\u0016\u001c\u0018AC2iCJ$H+\u001b;mK\u0006Q\u00110\u0011=jgRKG\u000f\\3\u0002\rqJg.\u001b;?)\u0019qt\bQ!C\u0007B\u0011q\u0003\u0001\u0005\u00065\u0019\u0001\r\u0001\b\u0005\u0006S\u0019\u0001\rA\u000b\u0005\u0006s\u0019\u0001\rA\u000b\u0005\u0006u\u0019\u0001\r\u0001\b\u0005\u0006w\u0019\u0001\r\u0001H\u0001\u0003UN,\u0012\u0001H\u0001\u0014e\u0016tG-\u001a:TG\u0006$H/\u001a:TKJLWm\u001d\u000b\u00059!SE\nC\u0003J\u0011\u0001\u0007!&\u0001\u0004tKJLWm\u001d\u0005\u0006\u0017\"\u0001\r\u0001H\u0001\u0005]\u0006lW\rC\u0003N\u0011\u0001\u0007a*A\u0003d_2|'\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R\u001f\u0005!Q\u000f^5m\u0013\t\u0019\u0006KA\u0003D_2|'/\u0001\u0003ii6d\u0007")
public final class ResponseTimeScatterTemplate
extends Template {
    private final String containerId;
    private final Seq<IntVsTimePlot> success;
    private final Seq<IntVsTimePlot> failures;
    private final String chartTitle;
    private final String yAxisTitle;

    @Override
    public String js() {
        return "\nnew Highcharts.Chart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    defaultSeriesType: 'scatter',\n    zoomType: 'xy',\n    marginBottom: 90\n  },\n  credits: { enabled: false },\n  xAxis: {\n    title: {\n      enabled: true,\n      text: 'Global number of requests per second',\n      style: { fontWeight: 'bold' }\n    },\n    startOnTick: true,\n    endOnTick: true,\n    showLastLabel: true,\n    min: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.chartTitle + "</span>',\n    useHTML: true\n  },\n  yAxis: {\n    min: 0,\n    title: { text: '" + this.yAxisTitle + "' }\n  },\n  tooltip: {\n    formatter: function() {\n         return ''+ this.y +' ms at ' + this.x + ' allreq/s';\n    }\n  },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: 0,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n  },\n  plotOptions: {\n    scatter: {\n      marker: {\n        radius: 3,\n        states: {\n          hover: {\n            enabled: true,\n            lineColor: 'rgb(100,100,100)'\n          }\n        }\n      },\n      states: {\n        hover: {\n          marker: { enabled: false }\n        }\n      }\n    }\n  },\n  series: [\n\t  {" + this.renderScatterSeries(this.success, Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok()) + "},\n\t  {" + this.renderScatterSeries(this.failures, Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko()) + "}\n\t]\n});\n";
    }

    private String renderScatterSeries(Seq<IntVsTimePlot> series, String name, Color color) {
        return "\ntype: 'scatter',\ncolor: '" + color + "',\nname: '" + name + "',\ndata: [\n" + ((IterableOnceOps)series.map((Function1 & Serializable)plot -> "[" + plot.time() + "," + plot.value() + "]")).mkString(",") + "\n]";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId + "\" class=\"geant\"></div>\n            </div>\n";
    }

    public ResponseTimeScatterTemplate(String containerId, Seq<IntVsTimePlot> success, Seq<IntVsTimePlot> failures, String chartTitle, String yAxisTitle) {
        this.containerId = containerId;
        this.success = success;
        this.failures = failures;
        this.chartTitle = chartTitle;
        this.yAxisTitle = yAxisTitle;
    }
}

