/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin;

import io.github.ascopes.protobufmavenplugin.generate.SourceGeneratorBuilder;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.jspecify.annotations.Nullable;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    @Component
    private @Nullable ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, property="protoc.version")
    private String protocVersion;
    @Parameter(property="grpc-plugin.version")
    private @Nullable String grpcPluginVersion;
    @Parameter
    private @Nullable Set<String> sourceDirectories;
    @Parameter
    private @Nullable String protobufOutputDirectory;
    @Parameter
    private @Nullable String grpcOutputDirectory;
    @Parameter(defaultValue="false")
    private boolean fatalWarnings;
    @Parameter(defaultValue="false")
    private boolean generateKotlinWrappers;
    @Parameter(defaultValue="false")
    private boolean liteOnly;

    protected AbstractGenerateMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        new SourceGeneratorBuilder().artifactResolver(this.artifactResolver).fatalWarnings(this.fatalWarnings).generateKotlinWrappers(this.generateKotlinWrappers).grpcOutputDirectory(this.getActualGrpcOutputDirectory()).grpcPluginVersion(this.grpcPluginVersion).liteOnly(this.liteOnly).mavenSession(this.mavenSession).protobufOutputDirectory(this.getActualProtobufOutputDirectory()).protocVersion(this.protocVersion).sourceDirectories(this.getActualSourceDirectories()).sourceRootRegistrar(this.getSourceRootRegistrar()).build().generate();
    }

    protected abstract Path getDefaultSourceDirectory(Path var1);

    protected abstract Path getDefaultProtobufOutputDirectory(Path var1);

    protected abstract Path getDefaultGrpcOutputDirectory(Path var1);

    protected abstract SourceRootRegistrar getSourceRootRegistrar();

    private Set<Path> getActualSourceDirectories() {
        if (this.sourceDirectories == null || this.sourceDirectories.isEmpty()) {
            Path baseDir = this.mavenSession.getCurrentProject().getBasedir().toPath();
            return Set.of(this.getDefaultSourceDirectory(baseDir));
        }
        return this.sourceDirectories.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toSet());
    }

    private Path getActualProtobufOutputDirectory() {
        if (this.protobufOutputDirectory == null || this.protobufOutputDirectory.isBlank()) {
            Path targetDir = Path.of(this.mavenSession.getCurrentProject().getBuild().getDirectory(), new String[0]);
            return this.getDefaultProtobufOutputDirectory(targetDir);
        }
        return Path.of(this.protobufOutputDirectory, new String[0]);
    }

    private Path getActualGrpcOutputDirectory() {
        if (this.grpcOutputDirectory == null || this.grpcOutputDirectory.isBlank()) {
            Path targetDir = Path.of(this.mavenSession.getCurrentProject().getBuild().getDirectory(), new String[0]);
            return this.getDefaultGrpcOutputDirectory(targetDir);
        }
        return Path.of(this.grpcOutputDirectory, new String[0]);
    }
}

