/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.execute;

import io.github.ascopes.protobufmavenplugin.execute.ProtocExecutionException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocExecutor.class);

    private ProtocExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(List<String> arguments) throws ProtocExecutionException {
        int exitCode;
        try {
            long elapsed;
            LOGGER.info("Invoking {}", arguments);
            long start = System.nanoTime();
            Process proc = new ProcessBuilder(arguments).redirectErrorStream(true).start();
            CompletableFuture<?> loggingFuture = ProtocExecutor.streamOutputAsLogs(proc.getInputStream());
            try {
                exitCode = proc.waitFor();
                elapsed = System.nanoTime() - start;
            }
            finally {
                try {
                    loggingFuture.join();
                }
                finally {
                    proc.destroy();
                }
            }
            LOGGER.info("Protoc {} after {}ms with exit code {}", new Object[]{exitCode == 0 ? "completed" : "terminated", elapsed / 1000000L, exitCode});
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ProtocExecutionException("Protoc execution was interrupted", ex);
        }
        catch (Exception ex) {
            LOGGER.debug("Execution failed due to an exception", (Throwable)ex);
            throw new ProtocExecutionException("An exception occurred while calling protoc", ex);
        }
        if (exitCode != 0) {
            throw new ProtocExecutionException(exitCode);
        }
    }

    private static CompletableFuture<?> streamOutputAsLogs(InputStream inputStream) {
        return CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LOGGER.info(">>> {}", (Object)line);
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Critical error reading output of subprocess", ex);
                throw new IllegalStateException("Critical error while reading process output");
            }
        });
    }
}

