/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.platform;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class HostEnvironment {
    public static boolean isWindows() {
        return HostEnvironment.operatingSystem().toLowerCase(Locale.ROOT).startsWith("windows");
    }

    public static boolean isMacOs() {
        return HostEnvironment.operatingSystem().toLowerCase(Locale.ROOT).startsWith("mac os");
    }

    public static boolean isLinux() {
        return HostEnvironment.operatingSystem().toLowerCase(Locale.ROOT).startsWith("linux");
    }

    public static String cpuArchitecture() {
        return Optional.ofNullable(System.getProperty("os.arch")).orElseThrow(() -> new IllegalStateException("No 'os.arch' system property is set"));
    }

    public static List<Path> systemPath() {
        String rawPath = HostEnvironment.environmentVariable("PATH").orElse("");
        try (Scanner scanner = new Scanner(rawPath).useDelimiter(File.pathSeparator);){
            List<Path> list = scanner.tokens().filter(Predicate.not(String::isBlank)).distinct().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toUnmodifiableList());
            return list;
        }
    }

    public static Set<String> systemPathExtensions() {
        String rawPathExtensions = HostEnvironment.environmentVariable("PATHEXT").orElse("");
        try (Scanner scanner = new Scanner(rawPathExtensions).useDelimiter(File.pathSeparator);){
            Set set = scanner.tokens().filter(Predicate.not(String::isBlank)).collect(HostEnvironment.toUnmodifiableSortedSet(String::compareToIgnoreCase));
            return set;
        }
    }

    public static Path workingDirectory() {
        return Path.of("", new String[0]).toAbsolutePath();
    }

    static Optional<String> environmentVariable(String name) {
        return Optional.ofNullable(System.getenv(name));
    }

    private static String operatingSystem() {
        return Optional.ofNullable(System.getProperty("os.name")).orElseThrow(() -> new IllegalStateException("No 'os.name' system property is set"));
    }

    private static <T> Collector<T, ?, SortedSet<T>> toUnmodifiableSortedSet(Comparator<T> comparator) {
        return Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(comparator)), Collections::unmodifiableSortedSet);
    }

    private HostEnvironment() {
    }
}

