/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.resolve;

import io.github.ascopes.protobufmavenplugin.platform.HostEnvironment;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolutionException;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;

public final class Executable {
    public static final Executable PROTOC = new Executable("com.google.protobuf", "protoc");
    public static final Executable PROTOC_GEN_GRPC_JAVA = new Executable("io.grpc", "protoc-gen-grpc-java");
    public static final Executable PROTOC_GEN_GRPC_KOTLIN = new Executable("io.grpc", "protoc-gen-grpc-kotlin");
    private final String groupId;
    private final String artifactId;

    public Executable(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String getExecutableName() {
        return this.artifactId;
    }

    public ArtifactCoordinate getMavenArtifactCoordinate(String version) throws ExecutableResolutionException {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(this.groupId);
        coordinate.setArtifactId(this.artifactId);
        coordinate.setVersion(version);
        coordinate.setClassifier(this.getMavenClassifier());
        coordinate.setExtension("exe");
        return coordinate;
    }

    protected final String getMavenClassifier() throws ExecutableResolutionException {
        String classifier;
        if (HostEnvironment.isWindows()) {
            classifier = "windows-" + this.determineArchitectureForWindows();
        } else if (HostEnvironment.isLinux()) {
            classifier = "linux-" + this.determineArchitectureForLinux();
        } else if (HostEnvironment.isMacOs()) {
            classifier = "osx-" + this.determineArchitectureForMacOs();
        } else {
            throw new ExecutableResolutionException("No resolvable version of " + this.artifactId + " for the current OS found");
        }
        return classifier;
    }

    protected String determineArchitectureForWindows() throws ExecutableResolutionException {
        String arch;
        switch (arch = HostEnvironment.cpuArchitecture()) {
            case "amd64": 
            case "x86_64": {
                return "x86_64";
            }
            case "x86": 
            case "x86_32": {
                return "x86_32";
            }
        }
        throw this.noResolvableExecutableFor("Windows", arch);
    }

    protected String determineArchitectureForLinux() throws ExecutableResolutionException {
        String arch;
        switch (arch = HostEnvironment.cpuArchitecture()) {
            case "ppc64le": 
            case "ppc64": {
                return "ppcle_64";
            }
            case "s390": 
            case "zarch_64": {
                return "s390_64";
            }
            case "aarch64": {
                return "aarch_64";
            }
            case "amd64": {
                return "x86_64";
            }
        }
        throw this.noResolvableExecutableFor("Linux", arch);
    }

    protected String determineArchitectureForMacOs() throws ExecutableResolutionException {
        String arch;
        switch (arch = HostEnvironment.cpuArchitecture()) {
            case "aarch64": {
                return "aarch_64";
            }
            case "amd64": 
            case "x86_64": {
                return "x86_64";
            }
        }
        throw this.noResolvableExecutableFor("Mac OS", arch);
    }

    protected ExecutableResolutionException noResolvableExecutableFor(String os, String arch) {
        String message = "No resolvable " + this.artifactId + " version for " + os + " '" + arch + "' systems found";
        return new ExecutableResolutionException(message);
    }
}

