/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.resolve;

import io.github.ascopes.protobufmavenplugin.platform.HostEnvironment;
import io.github.ascopes.protobufmavenplugin.resolve.Executable;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolutionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathExecutableResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathExecutableResolver.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path resolve(Executable executable) throws ExecutableResolutionException {
        String binaryName = executable.getExecutableName();
        Predicate<Path> predicate = HostEnvironment.isWindows() ? this.windowsMatchPredicate(binaryName) : this.posixMatchPredicate(binaryName);
        try {
            Iterator<Path> iterator = HostEnvironment.systemPath().iterator();
            while (iterator.hasNext()) {
                Path indexableDirectory = iterator.next();
                if (!Files.isDirectory(indexableDirectory, new LinkOption[0])) {
                    LOGGER.warn("Ignoring non-existent directory '{}' within $PATH", (Object)indexableDirectory);
                    continue;
                }
                LOGGER.debug("Searching directory '{}' for {} binary", (Object)indexableDirectory, (Object)binaryName);
                Stream<Path> fileStream = Files.list(indexableDirectory);
                try {
                    Path result = fileStream.peek(this.pathCandidateLogger(binaryName)).filter(predicate).findFirst().orElse(null);
                    if (result == null) continue;
                    LOGGER.info("Resolved {} binary to '{}'", (Object)binaryName, (Object)result);
                    Path path = result;
                    return path;
                }
                finally {
                    if (fileStream == null) continue;
                    fileStream.close();
                }
            }
            throw new ExecutableResolutionException("No " + binaryName + " binary was found in the $PATH");
        }
        catch (IOException ex) {
            throw new ExecutableResolutionException("File system error while searching for " + binaryName, ex);
        }
    }

    private Predicate<Path> windowsMatchPredicate(String binaryName) {
        Set<String> pathExt = HostEnvironment.systemPathExtensions();
        return path -> {
            String fileName = path.getFileName().toString();
            int fileExtensionIndex = fileName.lastIndexOf(46);
            String fileExtension = fileExtensionIndex < 0 ? "" : fileName.substring(fileExtensionIndex);
            String baseFileName = fileExtensionIndex < 0 ? fileName : fileName.substring(0, fileExtensionIndex);
            return baseFileName.equalsIgnoreCase(binaryName) && pathExt.contains(fileExtension);
        };
    }

    private Predicate<Path> posixMatchPredicate(String binaryName) {
        return path -> path.getFileName().toString().equals(binaryName) && Files.isExecutable(path);
    }

    private Consumer<Path> pathCandidateLogger(String binaryName) {
        return path -> LOGGER.trace("Checking if '{}' is a match for {}", path, (Object)binaryName);
    }
}

