/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.resolve;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtoSourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoSourceResolver.class);

    private ProtoSourceResolver() {
    }

    public static List<Path> resolve(Collection<Path> sourceDirs) throws IOException {
        ArrayList protoSources = new ArrayList();
        for (Path sourceDir : sourceDirs) {
            if (!Files.exists(sourceDir, new LinkOption[0])) {
                LOGGER.info("Source directory {} does not exist", (Object)sourceDir);
                continue;
            }
            LOGGER.info("Discovering protobuf sources in {}", (Object)sourceDir);
            Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);
            try {
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(ProtoSourceResolver.protoFileMatcher()).peek(ProtoSourceResolver.fileDiscoveryLogger()).forEach(protoSources::add);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        LOGGER.info("Discovered a total of {} protobuf source(s) to compile", (Object)protoSources.size());
        return Collections.unmodifiableList(protoSources);
    }

    private static Predicate<Path> protoFileMatcher() {
        return file -> {
            String fileName = file.getFileName().toString();
            int periodIndex = fileName.lastIndexOf(46);
            if (periodIndex == -1) {
                return false;
            }
            return fileName.substring(periodIndex).equals(".proto");
        };
    }

    private static Consumer<Path> fileDiscoveryLogger() {
        return file -> LOGGER.debug("Discovered protobuf source file at {}", file);
    }
}

