/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.system.FileUtils;
import io.github.ascopes.protobufmavenplugin.system.HostSystem;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class SystemPathBinaryResolver {
    private static final Logger log = LoggerFactory.getLogger(SystemPathBinaryResolver.class);
    private final HostSystem hostSystem;

    @Inject
    public SystemPathBinaryResolver(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    public Optional<Path> resolve(String name) throws ResolutionException {
        log.debug("Looking for executable matching name '{}' on the path", (Object)name);
        Predicate<Path> predicate = this.hostSystem.isProbablyWindows() ? this.isMatchWindows(name) : this.isMatchPosix(name);
        Optional<Path> result = Optional.empty();
        for (Path dir : this.hostSystem.getSystemPath()) {
            try {
                Stream<Path> files = Files.walk(dir, 1, new FileVisitOption[0]);
                try {
                    result = files.filter(predicate).findFirst();
                    if (!result.isPresent()) continue;
                    break;
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            catch (IOException ex) {
                throw new ResolutionException("An exception occurred while scanning the system PATH", ex);
            }
        }
        log.debug("Result for lookup of '{}' was {}", (Object)name, result);
        return result;
    }

    private Predicate<Path> isMatchWindows(String name) {
        log.debug("Using Windows path matching strategy");
        return path -> {
            boolean matchesName = FileUtils.getFileNameWithoutExtension(path).equalsIgnoreCase(name);
            boolean matchesExtension = FileUtils.getFileExtension(path).filter(this.hostSystem.getSystemPathExtensions()::contains).isPresent();
            log.debug("Matches name = {}, matches executable extension = {}", (Object)matchesName, (Object)matchesExtension);
            return matchesName && matchesExtension;
        };
    }

    private Predicate<Path> isMatchPosix(String name) {
        log.debug("Using POSIX path matching strategy");
        return path -> {
            boolean matchesName = path.getFileName().toString().equals(name);
            boolean matchesExecutableFlag = Files.isExecutable(path);
            log.debug("Matches name = {}, matches executable flag = {}", (Object)matchesName, (Object)matchesExecutableFlag);
            return matchesName && matchesExecutableFlag;
        };
    }
}

