/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.system;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public final class Digests {
    private Digests() {
    }

    public static String sha1(String data) {
        byte[] digest = Digests.createRawDigest("SHA-1", data.getBytes(StandardCharsets.UTF_8));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    private static byte[] createRawDigest(String algorithm, byte[] data) {
        try {
            return MessageDigest.getInstance(algorithm).digest(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

