/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.platform.Digests;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import io.github.ascopes.protobufmavenplugin.platform.HostSystem;
import io.github.ascopes.protobufmavenplugin.platform.Shlex;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;

@Named
public final class JvmPluginResolver {
    private static final Set<String> SCOPES = Set.of("compile", "runtime", "system");
    private final MavenProject mavenProject;
    private final HostSystem hostSystem;
    private final MavenDependencyPathResolver dependencyPathResolver;

    @Inject
    public JvmPluginResolver(MavenProject mavenProject, HostSystem hostSystem, MavenDependencyPathResolver dependencyPathResolver) {
        this.mavenProject = mavenProject;
        this.hostSystem = hostSystem;
        this.dependencyPathResolver = dependencyPathResolver;
    }

    public Collection<ResolvedPlugin> resolveMavenPlugins(MavenSession session, Collection<DependableCoordinate> plugins) throws IOException, ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (DependableCoordinate plugin : plugins) {
            resolvedPlugins.add(this.resolve(session, plugin));
        }
        return resolvedPlugins;
    }

    private ResolvedPlugin resolve(MavenSession session, DependableCoordinate plugin) throws IOException, ResolutionException {
        String scriptNamePrefix = this.pluginIdDigest(plugin);
        List<String> argLine = this.resolveAndBuildArgLine(session, plugin);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsBatchScript(scriptNamePrefix, argLine) : this.writeShellScript(scriptNamePrefix, argLine);
        return ImmutableResolvedPlugin.builder().id(UUID.randomUUID().toString()).path(scriptPath).build();
    }

    private List<String> resolveAndBuildArgLine(MavenSession session, DependableCoordinate pluginDependencyCoordinate) throws ResolutionException {
        Iterator<Path> dependencyIterator = this.dependencyPathResolver.resolveDependencyTreePaths(session, SCOPES, pluginDependencyCoordinate).iterator();
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        args.add("-jar");
        args.add(dependencyIterator.next().toString());
        if (dependencyIterator.hasNext()) {
            StringBuilder sb = new StringBuilder().append(dependencyIterator.next());
            while (dependencyIterator.hasNext()) {
                sb.append(":").append(dependencyIterator.next());
            }
            args.add("-classpath");
            args.add(sb.toString());
        }
        return args;
    }

    private String pluginIdDigest(DependableCoordinate dependableCoordinate) {
        String digestableString = String.join((CharSequence)":", Objects.requireNonNullElse(dependableCoordinate.getGroupId(), ""), Objects.requireNonNullElse(dependableCoordinate.getArtifactId(), ""), Objects.requireNonNullElse(dependableCoordinate.getVersion(), ""), Objects.requireNonNullElse(dependableCoordinate.getType(), ""), Objects.requireNonNullElse(dependableCoordinate.getClassifier(), ""));
        return Digests.sha1(digestableString);
    }

    private Path resolvePluginScriptPath() throws IOException {
        Path path = Path.of(this.mavenProject.getBuild().getDirectory(), new String[0]).resolve("protobuf-maven-plugin").resolve("jvm-plugins");
        return Files.createDirectories(path, new FileAttribute[0]);
    }

    private Path writeWindowsBatchScript(String scriptNamePrefix, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(scriptNamePrefix + ".bat");
        String script = "@echo off\r\n" + Shlex.quoteBatchArgs(argLine) + "\r\n";
        Files.writeString(fullScriptPath, (CharSequence)script, Charset.defaultCharset(), new OpenOption[0]);
        return fullScriptPath;
    }

    private Path writeShellScript(String scriptNamePrefix, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(scriptNamePrefix + ".sh");
        String script = "#!/usr/bin/env sh\nset -eu\n" + Shlex.quoteShellArgs(argLine) + "\n";
        Files.writeString(fullScriptPath, (CharSequence)script, Charset.defaultCharset(), new OpenOption[0]);
        FileUtils.makeExecutable(fullScriptPath);
        return fullScriptPath;
    }
}

